/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog;

import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.util.OptionRule;

public interface JdbcCatalogOptions {
    public static final Option<String> BASE_URL = Options.key((String)"base-url").stringType().noDefaultValue().withDescription("URL has to be with database, like \"jdbc:mysql://localhost:5432/db\" or\"jdbc:mysql://localhost:5432/db?useSSL=true\".");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("Name of the database to use when connecting to the database server.");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the database server.");
    public static final Option<String> SCHEMA = Options.key((String)"schema").stringType().noDefaultValue().withDescription("for databases that support the schema parameter, give it priority.");
    public static final Option<String> COMPATIBLE_MODE = Options.key((String)"compatibleMode").stringType().noDefaultValue().withDescription("The compatible mode of database, required when the database supports multiple compatible modes. For example, when using OceanBase database, you need to set it to 'mysql' or 'oracle'.");
    public static final OptionRule.Builder BASE_RULE = OptionRule.builder().required(new Option[]{BASE_URL}).required(new Option[]{USERNAME, PASSWORD}).optional(new Option[]{SCHEMA});
    public static final Option<String> TABLE_PREFIX = Options.key((String)"tablePrefix").stringType().noDefaultValue().withDescription("The table prefix name added when the table is automatically created");
    public static final Option<String> TABLE_SUFFIX = Options.key((String)"tableSuffix").stringType().noDefaultValue().withDescription("The table suffix name added when the table is automatically created");
    public static final Option<Boolean> CREATE_INDEX = Options.key((String)"create_index").booleanType().defaultValue((Object)true).withDescription("Create index or not when auto create table");
}

