/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config;

import com.google.common.base.Preconditions;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfigFactory;
import org.apache.seatunnel.connectors.cdc.debezium.EmbeddedDatabaseHistory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.ServerIdRange;

public class MySqlSourceConfigFactory
extends JdbcSourceConfigFactory {
    private ServerIdRange serverIdRange;

    public MySqlSourceConfigFactory serverId(String serverId) {
        this.serverIdRange = ServerIdRange.from(serverId);
        return this;
    }

    @Override
    public MySqlSourceConfig create(int subtaskId) {
        Properties props = new Properties();
        props.setProperty("database.server.name", "mysql_binlog_source");
        props.setProperty("database.hostname", Preconditions.checkNotNull(this.hostname));
        props.setProperty("database.user", Preconditions.checkNotNull(this.username));
        props.setProperty("database.password", Preconditions.checkNotNull(this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("database.fetchSize", String.valueOf(this.fetchSize));
        props.setProperty("database.responseBuffering", "adaptive");
        props.setProperty("database.serverTimezone", this.serverTimeZone);
        props.setProperty("database.history", EmbeddedDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID() + "_" + subtaskId);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("connect.timeout.ms", String.valueOf(this.connectTimeoutMillis));
        props.setProperty("include.schema.changes", String.valueOf(false));
        props.setProperty("offset.flush.interval.ms", String.valueOf(Long.MAX_VALUE));
        props.setProperty("tombstones.on.delete", String.valueOf(false));
        props.put("bigint.unsigned.handling.mode", "precise");
        if (this.serverIdRange != null) {
            props.setProperty("database.server.id.range", String.valueOf(this.serverIdRange));
            long serverId = this.serverIdRange.getServerId(subtaskId);
            props.setProperty("database.server.id", String.valueOf(serverId));
        }
        if (this.databaseList != null) {
            props.setProperty("database.include.list", String.join((CharSequence)",", this.databaseList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
        }
        if (this.serverTimeZone != null) {
            props.setProperty("database.serverTimezone", this.serverTimeZone);
        }
        if (this.dbzProperties != null) {
            this.dbzProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)props::put));
        }
        Configuration dbzConfiguration = Configuration.from(props);
        String driverClassName = dbzConfiguration.getString(MySqlConnectorConfig.JDBC_DRIVER);
        return new MySqlSourceConfig(this.startupConfig, this.stopConfig, this.databaseList, this.tableList, this.splitSize, this.distributionFactorUpper, this.distributionFactorLower, this.sampleShardingThreshold, this.inverseSamplingRate, props, driverClassName, this.hostname, this.port, this.username, this.password, this.originUrl, this.fetchSize, this.serverTimeZone, this.connectTimeoutMillis, this.connectMaxRetries, this.connectionPoolSize, this.exactlyOnce);
    }
}

