/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.luben.zstd.Zstd;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TransactionPayloadEventDataDeserializer
implements EventDataDeserializer<TransactionPayloadEventData> {
    public static final int OTW_PAYLOAD_HEADER_END_MARK = 0;
    public static final int OTW_PAYLOAD_SIZE_FIELD = 1;
    public static final int OTW_PAYLOAD_COMPRESSION_TYPE_FIELD = 2;
    public static final int OTW_PAYLOAD_UNCOMPRESSED_SIZE_FIELD = 3;

    @Override
    public TransactionPayloadEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TransactionPayloadEventData eventData = new TransactionPayloadEventData();
        block5: while (inputStream.available() > 0) {
            int fieldType = 0;
            int fieldLen = 0;
            if (inputStream.available() >= 1) {
                fieldType = inputStream.readPackedInteger();
            }
            if (fieldType == 0) break;
            if (inputStream.available() >= 1) {
                fieldLen = inputStream.readPackedInteger();
            }
            switch (fieldType) {
                case 1: {
                    eventData.setPayloadSize(inputStream.readPackedInteger());
                    continue block5;
                }
                case 2: {
                    eventData.setCompressionType(inputStream.readPackedInteger());
                    continue block5;
                }
                case 3: {
                    eventData.setUncompressedSize(inputStream.readPackedInteger());
                    continue block5;
                }
            }
            inputStream.read(fieldLen);
        }
        if (eventData.getUncompressedSize() == 0) {
            eventData.setUncompressedSize(eventData.getPayloadSize());
        }
        eventData.setPayload(inputStream.read(eventData.getPayloadSize()));
        byte[] src = eventData.getPayload();
        byte[] dst = ByteBuffer.allocate(eventData.getUncompressedSize()).array();
        Zstd.decompressByteArray(dst, 0, dst.length, src, 0, src.length);
        ArrayList<Event> decompressedEvents = new ArrayList<Event>();
        EventDeserializer transactionPayloadEventDeserializer = new EventDeserializer();
        ByteArrayInputStream destinationInputStream = new ByteArrayInputStream(dst);
        Event internalEvent = transactionPayloadEventDeserializer.nextEvent(destinationInputStream);
        while (internalEvent != null) {
            decompressedEvents.add(internalEvent);
            internalEvent = transactionPayloadEventDeserializer.nextEvent(destinationInputStream);
        }
        eventData.setUncompressedEvents(decompressedEvents);
        return eventData;
    }
}

