/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.raw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.RawCASConflictException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.importer.ImporterClient;
import org.tikv.common.importer.SwitchTiKVModeClient;
import org.tikv.common.key.Key;
import org.tikv.common.log.SlowLogEmptyImpl;
import org.tikv.common.log.SlowLogImpl;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.common.operation.iterator.RawScanIterator;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.Batch;
import org.tikv.common.util.ClientUtils;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.DeleteRange;
import org.tikv.common.util.HistogramUtils;
import org.tikv.common.util.Pair;
import org.tikv.common.util.ScanOption;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.raw.RawKVClientBase;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.prometheus.client.Counter;
import org.tikv.shade.io.prometheus.client.Histogram;

public class RawKVClient
implements RawKVClientBase {
    private final TiSession tiSession;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private final TiConfiguration conf;
    private final boolean atomicForCAS;
    private final ExecutorService batchGetThreadPool;
    private final ExecutorService batchPutThreadPool;
    private final ExecutorService batchDeleteThreadPool;
    private final ExecutorService batchScanThreadPool;
    private final ExecutorService deleteRangeThreadPool;
    private static final Logger logger = LoggerFactory.getLogger(RawKVClient.class);
    public static final Histogram RAW_REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_raw_requests_latency")).help("client raw request latency.")).labelNames("type")).register();
    public static final Counter RAW_REQUEST_SUCCESS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_raw_requests_success")).help("client raw request success.")).labelNames("type")).register();
    public static final Counter RAW_REQUEST_FAILURE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_raw_requests_failure")).help("client raw request failure.")).labelNames("type")).register();
    private static final TiKVException ERR_MAX_SCAN_LIMIT_EXCEEDED = new TiKVException("limit should be less than MAX_RAW_SCAN_LIMIT");

    public RawKVClient(TiSession session, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(clientBuilder, "clientBuilder is null");
        this.conf = session.getConf();
        this.tiSession = session;
        this.clientBuilder = clientBuilder;
        this.batchGetThreadPool = session.getThreadPoolForBatchGet();
        this.batchPutThreadPool = session.getThreadPoolForBatchPut();
        this.batchDeleteThreadPool = session.getThreadPoolForBatchDelete();
        this.batchScanThreadPool = session.getThreadPoolForBatchScan();
        this.deleteRangeThreadPool = session.getThreadPoolForDeleteRange();
        this.atomicForCAS = this.conf.isEnableAtomicForCAS();
    }

    @Override
    public void close() {
    }

    @Override
    public void put(ByteString key, ByteString value) {
        this.put(key, value, 0L);
    }

    /*
     * Loose catch block
     */
    @Override
    public void put(ByteString key, ByteString value, long ttl) {
        String label = "client_raw_put";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVWriteSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("put");
        span.addProperty("key", KeyUtils.formatBytesUTF8(key));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVWriteTimeoutInMS(), slowLog);
        while (true) {
            Throwable throwable;
            RegionStoreClient client;
            block19: {
                block20: {
                    client = this.clientBuilder.build(key, (BackOffer)backOffer);
                    throwable = null;
                    span.addProperty("region", client.getRegion().toString());
                    client.rawPut(backOffer, key, value, ttl, this.atomicForCAS);
                    ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
                    if (client == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                client.close();
            }
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
            return;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (client != null) {
                                        if (throwable != null) {
                                            try {
                                                client.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            client.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (TiKVException e) {
                                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                                logger.warn("Retry for put error", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
                            slowLog.setError(e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable6) {
                        requestTimer.observeDuration();
                        span.end();
                        slowLog.log();
                        throw throwable6;
                    }
                }
            }
        }
    }

    @Override
    public Optional<ByteString> putIfAbsent(ByteString key, ByteString value) {
        return this.putIfAbsent(key, value, 0L);
    }

    @Override
    public Optional<ByteString> putIfAbsent(ByteString key, ByteString value, long ttl) {
        try {
            this.compareAndSet(key, Optional.empty(), value, ttl);
            return Optional.empty();
        }
        catch (RawCASConflictException e) {
            return e.getPrevValue();
        }
    }

    @Override
    public void compareAndSet(ByteString key, Optional<ByteString> prevValue, ByteString value) throws RawCASConflictException {
        this.compareAndSet(key, prevValue, value, 0L);
    }

    /*
     * Loose catch block
     */
    @Override
    public void compareAndSet(ByteString key, Optional<ByteString> prevValue, ByteString value, long ttl) throws RawCASConflictException {
        if (!this.atomicForCAS) {
            throw new IllegalArgumentException("To use compareAndSet or putIfAbsent, please enable the config tikv.enable_atomic_for_cas.");
        }
        String label = "client_raw_compare_and_set";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVWriteSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("putIfAbsent");
        span.addProperty("key", KeyUtils.formatBytesUTF8(key));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVWriteTimeoutInMS(), slowLog);
        while (true) {
            Throwable throwable;
            RegionStoreClient client;
            block20: {
                block21: {
                    client = this.clientBuilder.build(key, (BackOffer)backOffer);
                    throwable = null;
                    span.addProperty("region", client.getRegion().toString());
                    client.rawCompareAndSet(backOffer, key, prevValue, value, ttl);
                    ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
                    if (client == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                client.close();
            }
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
            return;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (client != null) {
                                        if (throwable != null) {
                                            try {
                                                client.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            client.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (TiKVException e) {
                                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                                logger.warn("Retry for putIfAbsent error", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
                            slowLog.setError(e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable6) {
                        requestTimer.observeDuration();
                        span.end();
                        slowLog.log();
                        throw throwable6;
                    }
                }
            }
        }
    }

    @Override
    public void batchPut(Map<ByteString, ByteString> kvPairs) {
        this.batchPut(kvPairs, 0L);
    }

    @Override
    public void batchPut(Map<ByteString, ByteString> kvPairs, long ttl) {
        String label = "client_raw_batch_put";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVBatchWriteSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("batchPut");
        span.addProperty("keySize", String.valueOf(kvPairs.size()));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVBatchWriteTimeoutInMS(), slowLog);
        try {
            long deadline = System.currentTimeMillis() + (long)this.conf.getRawKVBatchWriteTimeoutInMS();
            this.doSendBatchPut(backOffer, kvPairs, ttl, deadline);
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            slowLog.setError(e);
            throw e;
        }
        finally {
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Optional<ByteString> get(ByteString key) {
        String label = "client_raw_get";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVReadSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("get");
        span.addProperty("key", KeyUtils.formatBytesUTF8(key));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVReadTimeoutInMS(), slowLog);
        while (true) {
            Optional<ByteString> optional;
            Throwable throwable;
            RegionStoreClient client;
            block19: {
                block20: {
                    client = this.clientBuilder.build(key, (BackOffer)backOffer);
                    throwable = null;
                    span.addProperty("region", client.getRegion().toString());
                    Optional<ByteString> result = client.rawGet(backOffer, key);
                    ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
                    optional = result;
                    if (client == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                client.close();
            }
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
            return optional;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (client != null) {
                                        if (throwable != null) {
                                            try {
                                                client.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            client.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (TiKVException e) {
                                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                                logger.warn("Retry for get error", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
                            slowLog.setError(e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable6) {
                        requestTimer.observeDuration();
                        span.end();
                        slowLog.log();
                        throw throwable6;
                    }
                }
            }
        }
    }

    @Override
    public List<Kvrpcpb.KvPair> batchGet(List<ByteString> keys) {
        String label = "client_raw_batch_get";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVBatchReadSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("batchGet");
        span.addProperty("keySize", String.valueOf(keys.size()));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVBatchReadTimeoutInMS(), slowLog);
        try {
            long deadline = System.currentTimeMillis() + (long)this.conf.getRawKVBatchReadTimeoutInMS();
            List<Kvrpcpb.KvPair> result = this.doSendBatchGet(backOffer, keys, deadline);
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
            List<Kvrpcpb.KvPair> list = result;
            return list;
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            slowLog.setError(e);
            throw e;
        }
        finally {
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
        }
    }

    @Override
    public void batchDelete(List<ByteString> keys) {
        String label = "client_raw_batch_delete";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVBatchWriteSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("batchDelete");
        span.addProperty("keySize", String.valueOf(keys.size()));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVBatchWriteTimeoutInMS(), slowLog);
        try {
            long deadline = System.currentTimeMillis() + (long)this.conf.getRawKVBatchWriteTimeoutInMS();
            this.doSendBatchDelete(backOffer, keys, deadline);
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
            return;
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            slowLog.setError(e);
            throw e;
        }
        finally {
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Optional<Long> getKeyTTL(ByteString key) {
        String label = "client_raw_get_key_ttl";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVReadSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("getKeyTTL");
        span.addProperty("key", KeyUtils.formatBytesUTF8(key));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVReadTimeoutInMS(), slowLog);
        while (true) {
            Optional<Long> optional;
            Throwable throwable;
            RegionStoreClient client;
            block19: {
                block20: {
                    client = this.clientBuilder.build(key, (BackOffer)backOffer);
                    throwable = null;
                    span.addProperty("region", client.getRegion().toString());
                    Optional<Long> result = client.rawGetKeyTTL(backOffer, key);
                    ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
                    optional = result;
                    if (client == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                client.close();
            }
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
            return optional;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (client != null) {
                                        if (throwable != null) {
                                            try {
                                                client.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            client.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (TiKVException e) {
                                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                                logger.warn("Retry for getKeyTTL error", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
                            slowLog.setError(e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable6) {
                        requestTimer.observeDuration();
                        span.end();
                        slowLog.log();
                        throw throwable6;
                    }
                }
            }
        }
    }

    @Override
    public List<List<ByteString>> batchScanKeys(List<Pair<ByteString, ByteString>> ranges, int eachLimit) {
        return this.batchScan(ranges.stream().map(range -> ScanOption.newBuilder().setStartKey((ByteString)range.first).setEndKey((ByteString)range.second).setLimit(eachLimit).setKeyOnly(true).build()).collect(Collectors.toList())).stream().map(kvs -> kvs.stream().map(kv -> kv.getKey()).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Override
    public List<List<Kvrpcpb.KvPair>> batchScan(List<ScanOption> ranges) {
        String label = "client_raw_batch_scan";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        long deadline = System.currentTimeMillis() + (long)this.conf.getRawKVScanTimeoutInMS();
        ArrayList<Future<Pair>> futureList = new ArrayList<Future<Pair>>();
        try {
            int i;
            if (ranges.isEmpty()) {
                ArrayList<List<Kvrpcpb.KvPair>> arrayList = new ArrayList<List<Kvrpcpb.KvPair>>();
                return arrayList;
            }
            ExecutorCompletionService<Pair> completionService = new ExecutorCompletionService<Pair>(this.batchScanThreadPool);
            int num = 0;
            for (ScanOption scanOption : ranges) {
                int i2 = num++;
                futureList.add(completionService.submit(() -> Pair.create(i2, this.scan(scanOption))));
            }
            ArrayList<List<Kvrpcpb.KvPair>> arrayList = new ArrayList<List<Kvrpcpb.KvPair>>();
            for (i = 0; i < num; ++i) {
                arrayList.add(new ArrayList());
            }
            for (i = 0; i < num; ++i) {
                try {
                    Future future = completionService.poll(deadline - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    if (future == null) {
                        throw new TiKVException("TimeOut Exceeded for current operation.");
                    }
                    Pair scanResult = (Pair)future.get();
                    arrayList.set((Integer)scanResult.first, (List<Kvrpcpb.KvPair>)scanResult.second);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TiKVException("Current thread interrupted.", e);
                }
                catch (ExecutionException e) {
                    throw new TiKVException("Execution exception met.", e);
                }
            }
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
            ArrayList<List<Kvrpcpb.KvPair>> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            for (Future future : futureList) {
                future.cancel(true);
            }
            throw e;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, int limit) {
        return this.scan(startKey, endKey, limit, false);
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, int limit, boolean keyOnly) {
        String label = "client_raw_scan";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVScanSlowLogInMS());
        SlowLogSpan span = slowLog.start("scan");
        span.addProperty("startKey", KeyUtils.formatBytesUTF8(startKey));
        span.addProperty("endKey", KeyUtils.formatBytesUTF8(endKey));
        span.addProperty("limit", String.valueOf(limit));
        span.addProperty("keyOnly", String.valueOf(keyOnly));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVScanTimeoutInMS(), slowLog);
        try {
            Iterator<Kvrpcpb.KvPair> iterator = this.rawScanIterator(this.conf, this.clientBuilder, startKey, endKey, limit, keyOnly, backOffer);
            ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
            iterator.forEachRemaining(result::add);
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
            ArrayList<Kvrpcpb.KvPair> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            slowLog.setError(e);
            throw e;
        }
        finally {
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
        }
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, int limit) {
        return this.scan(startKey, limit, false);
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, int limit, boolean keyOnly) {
        return this.scan(startKey, ByteString.EMPTY, limit, keyOnly);
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey) {
        return this.scan(startKey, endKey, false);
    }

    @Override
    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, boolean keyOnly) {
        String label = "client_raw_scan_without_limit";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVScanSlowLogInMS());
        SlowLogSpan span = slowLog.start("scan");
        span.addProperty("startKey", KeyUtils.formatBytesUTF8(startKey));
        span.addProperty("endKey", KeyUtils.formatBytesUTF8(endKey));
        span.addProperty("keyOnly", String.valueOf(keyOnly));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVScanTimeoutInMS(), slowLog);
        try {
            Iterator<Kvrpcpb.KvPair> iterator;
            ByteString newStartKey = startKey;
            ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
            while ((iterator = this.rawScanIterator(this.conf, this.clientBuilder, newStartKey, endKey, this.conf.getScanBatchSize(), keyOnly, backOffer)).hasNext()) {
                iterator.forEachRemaining(result::add);
                newStartKey = Key.toRawKey(((Kvrpcpb.KvPair)result.get(result.size() - 1)).getKey()).next().toByteString();
            }
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
            ArrayList<Kvrpcpb.KvPair> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            slowLog.setError(e);
            throw e;
        }
        finally {
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
        }
    }

    private List<Kvrpcpb.KvPair> scan(ScanOption scanOption) {
        ByteString startKey = scanOption.getStartKey();
        ByteString endKey = scanOption.getEndKey();
        int limit = scanOption.getLimit();
        boolean keyOnly = scanOption.isKeyOnly();
        return this.scan(startKey, endKey, limit, keyOnly);
    }

    @Override
    public List<Kvrpcpb.KvPair> scanPrefix(ByteString prefixKey, int limit, boolean keyOnly) {
        return this.scan(prefixKey, Key.toRawKey(prefixKey).nextPrefix().toByteString(), limit, keyOnly);
    }

    @Override
    public List<Kvrpcpb.KvPair> scanPrefix(ByteString prefixKey) {
        return this.scan(prefixKey, Key.toRawKey(prefixKey).nextPrefix().toByteString());
    }

    @Override
    public List<Kvrpcpb.KvPair> scanPrefix(ByteString prefixKey, boolean keyOnly) {
        return this.scan(prefixKey, Key.toRawKey(prefixKey).nextPrefix().toByteString(), keyOnly);
    }

    /*
     * Loose catch block
     */
    @Override
    public void delete(ByteString key) {
        String label = "client_raw_delete";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        SlowLogImpl slowLog = new SlowLogImpl(this.conf.getRawKVWriteSlowLogInMS().intValue());
        SlowLogSpan span = slowLog.start("delete");
        span.addProperty("key", KeyUtils.formatBytesUTF8(key));
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVWriteTimeoutInMS(), slowLog);
        while (true) {
            Throwable throwable;
            RegionStoreClient client;
            block19: {
                block20: {
                    client = this.clientBuilder.build(key, (BackOffer)backOffer);
                    throwable = null;
                    span.addProperty("region", client.getRegion().toString());
                    client.rawDelete(backOffer, key, this.atomicForCAS);
                    ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
                    if (client == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                client.close();
            }
            requestTimer.observeDuration();
            span.end();
            slowLog.log();
            return;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (client != null) {
                                        if (throwable != null) {
                                            try {
                                                client.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                            }
                                        } else {
                                            client.close();
                                        }
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (TiKVException e) {
                                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                                logger.warn("Retry for delete error", (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
                            slowLog.setError(e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable6) {
                        requestTimer.observeDuration();
                        span.end();
                        slowLog.log();
                        throw throwable6;
                    }
                }
            }
        }
    }

    @Override
    public synchronized void deleteRange(ByteString startKey, ByteString endKey) {
        String label = "client_raw_delete_range";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        ConcreteBackOffer backOffer = ConcreteBackOffer.newDeadlineBackOff(this.conf.getRawKVCleanTimeoutInMS(), SlowLogEmptyImpl.INSTANCE);
        try {
            long deadline = System.currentTimeMillis() + (long)this.conf.getRawKVCleanTimeoutInMS();
            this.doSendDeleteRange(backOffer, startKey, endKey, deadline);
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            throw e;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    @Override
    public synchronized void deletePrefix(ByteString key) {
        ByteString endKey = Key.toRawKey(key).nextPrefix().toByteString();
        this.deleteRange(key, endKey);
    }

    public synchronized void ingest(List<Pair<ByteString, ByteString>> list) {
        this.ingest(list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ingest(List<Pair<ByteString, ByteString>> list, Long ttl) throws GrpcException {
        if (list.isEmpty()) {
            return;
        }
        Key min2 = Key.MAX;
        Key max = Key.MIN;
        HashMap map = new HashMap(list.size());
        for (Pair<ByteString, ByteString> pair2 : list) {
            map.put(pair2.first, pair2.second);
            Key key = Key.toRawKey(((ByteString)pair2.first).toByteArray());
            if (key.compareTo(min2) < 0) {
                min2 = key;
            }
            if (key.compareTo(max) <= 0) continue;
            max = key;
        }
        SwitchTiKVModeClient switchTiKVModeClient = this.tiSession.getSwitchTiKVModeClient();
        try {
            switchTiKVModeClient.switchTiKVToNormalMode();
            ArrayList<byte[]> splitKeys = new ArrayList<byte[]>(2);
            splitKeys.add(min2.getBytes());
            splitKeys.add(max.next().getBytes());
            this.tiSession.splitRegionAndScatter(splitKeys);
            this.tiSession.getRegionManager().invalidateAll();
            switchTiKVModeClient.keepTiKVToImportMode();
            List<ByteString> keyList = list.stream().map(pair -> (ByteString)pair.first).collect(Collectors.toList());
            Map<TiRegion, List<ByteString>> groupKeys = ClientUtils.groupKeysByRegion(this.clientBuilder.getRegionManager(), keyList, this.defaultBackOff());
            for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
                TiRegion region = entry.getKey();
                List<ByteString> keys = entry.getValue();
                List<Pair<ByteString, ByteString>> kvs = keys.stream().map(k -> Pair.create(k, map.get(k))).collect(Collectors.toList());
                this.doIngest(region, kvs, ttl);
            }
        }
        finally {
            switchTiKVModeClient.stopKeepTiKVToImportMode();
            switchTiKVModeClient.switchTiKVToNormalMode();
        }
    }

    private void doIngest(TiRegion region, List<Pair<ByteString, ByteString>> sortedList, Long ttl) throws GrpcException {
        if (sortedList.isEmpty()) {
            return;
        }
        ByteString uuid = ByteString.copyFrom(ClientUtils.genUUID());
        Key minKey = Key.toRawKey((ByteString)sortedList.get((int)0).first);
        Key maxKey = Key.toRawKey((ByteString)sortedList.get((int)(sortedList.size() - 1)).first);
        ImporterClient importerClient = new ImporterClient(this.tiSession, uuid, minKey, maxKey, region, ttl);
        importerClient.write(sortedList.iterator());
    }

    private void doSendBatchPut(BackOffer backOffer, Map<ByteString, ByteString> kvPairs, long ttl, long deadline) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.batchPutThreadPool);
        ArrayList futureList = new ArrayList();
        Map<TiRegion, List<ByteString>> groupKeys = ClientUtils.groupKeysByRegion(this.clientBuilder.getRegionManager(), kvPairs.keySet(), backOffer);
        ArrayList<Batch> batches = new ArrayList<Batch>();
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            ClientUtils.appendBatches(backOffer, batches, entry.getKey(), entry.getValue(), entry.getValue().stream().map(kvPairs::get).collect(Collectors.toList()), 0x100000, 1024);
        }
        LinkedList taskQueue = new LinkedList();
        taskQueue.offer(batches);
        while (!taskQueue.isEmpty()) {
            List task = (List)taskQueue.poll();
            for (Batch batch : task) {
                completionService.submit(() -> this.doSendBatchPutInBatchesWithRetry(batch.getBackOffer(), batch, ttl));
                try {
                    ClientUtils.getTasks(completionService, taskQueue, task, deadline - System.currentTimeMillis());
                }
                catch (Exception e) {
                    for (Future future : futureList) {
                        future.cancel(true);
                    }
                    throw e;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Batch> doSendBatchPutInBatchesWithRetry(BackOffer backOffer, Batch batch, long ttl) {
        try (RegionStoreClient client = this.clientBuilder.build(batch.getRegion(), backOffer);){
            client.setTimeout(this.conf.getRawKVBatchWriteTimeoutInMS());
            client.rawBatchPut(backOffer, batch, ttl, this.atomicForCAS);
            ArrayList<Batch> arrayList = new ArrayList<Batch>();
            return arrayList;
        }
        catch (TiKVException e) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
            logger.warn("ReSplitting ranges for BatchPutRequest", (Throwable)e);
            return this.doSendBatchPutWithRefetchRegion(backOffer, batch);
        }
    }

    private List<Batch> doSendBatchPutWithRefetchRegion(BackOffer backOffer, Batch batch) {
        Map<TiRegion, List<ByteString>> groupKeys = ClientUtils.groupKeysByRegion(this.clientBuilder.getRegionManager(), batch.getKeys(), backOffer);
        ArrayList<Batch> retryBatches = new ArrayList<Batch>();
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            ClientUtils.appendBatches(backOffer, retryBatches, entry.getKey(), entry.getValue(), entry.getValue().stream().map(batch.getMap()::get).collect(Collectors.toList()), 0x100000, 1024);
        }
        return retryBatches;
    }

    private List<Kvrpcpb.KvPair> doSendBatchGet(BackOffer backOffer, List<ByteString> keys, long deadline) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.batchGetThreadPool);
        ArrayList<Future<Pair>> futureList = new ArrayList<Future<Pair>>();
        List<Batch> batches = ClientUtils.getBatches(backOffer, keys, 16384, 1024, this.clientBuilder);
        LinkedList taskQueue = new LinkedList();
        ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
        taskQueue.offer(batches);
        while (!taskQueue.isEmpty()) {
            List task = (List)taskQueue.poll();
            for (Batch batch : task) {
                futureList.add(completionService.submit(() -> this.doSendBatchGetInBatchesWithRetry(batch.getBackOffer(), batch)));
            }
            try {
                result.addAll(ClientUtils.getTasksWithOutput(completionService, taskQueue, task, deadline - System.currentTimeMillis()));
            }
            catch (Exception e) {
                for (Future future : futureList) {
                    future.cancel(true);
                }
                throw e;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<List<Batch>, List<Kvrpcpb.KvPair>> doSendBatchGetInBatchesWithRetry(BackOffer backOffer, Batch batch) {
        try (RegionStoreClient client = this.clientBuilder.build(batch.getRegion(), backOffer);){
            List<Kvrpcpb.KvPair> partialResult = client.rawBatchGet(backOffer, batch.getKeys());
            Pair<List<Batch>, List<Kvrpcpb.KvPair>> pair = Pair.create(new ArrayList(), partialResult);
            return pair;
        }
        catch (TiKVException e) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
            this.clientBuilder.getRegionManager().invalidateRegion(batch.getRegion());
            logger.warn("ReSplitting ranges for BatchGetRequest", (Throwable)e);
            return Pair.create(this.doSendBatchGetWithRefetchRegion(backOffer, batch), new ArrayList());
        }
    }

    private List<Batch> doSendBatchGetWithRefetchRegion(BackOffer backOffer, Batch batch) {
        return ClientUtils.getBatches(backOffer, batch.getKeys(), 16384, 1024, this.clientBuilder);
    }

    private void doSendBatchDelete(BackOffer backOffer, List<ByteString> keys, long deadline) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.batchDeleteThreadPool);
        ArrayList<Future<List>> futureList = new ArrayList<Future<List>>();
        List<Batch> batches = ClientUtils.getBatches(backOffer, keys, 16384, 1024, this.clientBuilder);
        LinkedList taskQueue = new LinkedList();
        taskQueue.offer(batches);
        while (!taskQueue.isEmpty()) {
            List task = (List)taskQueue.poll();
            for (Batch batch : task) {
                futureList.add(completionService.submit(() -> this.doSendBatchDeleteInBatchesWithRetry(batch.getBackOffer(), batch)));
            }
            try {
                ClientUtils.getTasks(completionService, taskQueue, task, deadline - System.currentTimeMillis());
            }
            catch (Exception e) {
                for (Future future : futureList) {
                    future.cancel(true);
                }
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Batch> doSendBatchDeleteInBatchesWithRetry(BackOffer backOffer, Batch batch) {
        try (RegionStoreClient client = this.clientBuilder.build(batch.getRegion(), backOffer);){
            client.rawBatchDelete(backOffer, batch.getKeys(), this.atomicForCAS);
            ArrayList<Batch> arrayList = new ArrayList<Batch>();
            return arrayList;
        }
        catch (TiKVException e) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
            this.clientBuilder.getRegionManager().invalidateRegion(batch.getRegion());
            logger.warn("ReSplitting ranges for BatchGetRequest", (Throwable)e);
            return this.doSendBatchDeleteWithRefetchRegion(backOffer, batch);
        }
    }

    private List<Batch> doSendBatchDeleteWithRefetchRegion(BackOffer backOffer, Batch batch) {
        return ClientUtils.getBatches(backOffer, batch.getKeys(), 16384, 1024, this.clientBuilder);
    }

    private ByteString calcKeyByCondition(boolean condition, ByteString key1, ByteString key2) {
        if (condition) {
            return key1;
        }
        return key2;
    }

    private void doSendDeleteRange(BackOffer backOffer, ByteString startKey, ByteString endKey, long deadline) {
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.deleteRangeThreadPool);
        ArrayList<Future<List>> futureList = new ArrayList<Future<List>>();
        List<TiRegion> regions = this.fetchRegionsFromRange(backOffer, startKey, endKey);
        ArrayList<DeleteRange> ranges = new ArrayList<DeleteRange>();
        for (int i = 0; i < regions.size(); ++i) {
            TiRegion region = regions.get(i);
            ByteString start = this.calcKeyByCondition(i == 0, startKey, region.getStartKey());
            ByteString end = this.calcKeyByCondition(i == regions.size() - 1, endKey, region.getEndKey());
            ranges.add(new DeleteRange(backOffer, region, start, end));
        }
        LinkedList taskQueue = new LinkedList();
        taskQueue.offer(ranges);
        while (!taskQueue.isEmpty()) {
            List task = (List)taskQueue.poll();
            for (DeleteRange range : task) {
                futureList.add(completionService.submit(() -> this.doSendDeleteRangeWithRetry(range.getBackOffer(), range)));
            }
            try {
                ClientUtils.getTasks(completionService, taskQueue, task, deadline - System.currentTimeMillis());
            }
            catch (Exception e) {
                for (Future future : futureList) {
                    future.cancel(true);
                }
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DeleteRange> doSendDeleteRangeWithRetry(BackOffer backOffer, DeleteRange range) {
        try (RegionStoreClient client = this.clientBuilder.build(range.getRegion(), backOffer);){
            client.setTimeout(this.conf.getScanTimeout());
            client.rawDeleteRange(backOffer, range.getStartKey(), range.getEndKey());
            ArrayList<DeleteRange> arrayList = new ArrayList<DeleteRange>();
            return arrayList;
        }
        catch (TiKVException e) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
            this.clientBuilder.getRegionManager().invalidateRegion(range.getRegion());
            logger.warn("ReSplitting ranges for BatchDeleteRangeRequest", (Throwable)e);
            return this.doSendDeleteRangeWithRefetchRegion(backOffer, range);
        }
    }

    private List<DeleteRange> doSendDeleteRangeWithRefetchRegion(BackOffer backOffer, DeleteRange range) {
        List<TiRegion> regions = this.fetchRegionsFromRange(backOffer, range.getStartKey(), range.getEndKey());
        ArrayList<DeleteRange> retryRanges = new ArrayList<DeleteRange>();
        for (int i = 0; i < regions.size(); ++i) {
            TiRegion region = regions.get(i);
            ByteString start = this.calcKeyByCondition(i == 0, range.getStartKey(), region.getStartKey());
            ByteString end = this.calcKeyByCondition(i == regions.size() - 1, range.getEndKey(), region.getEndKey());
            retryRanges.add(new DeleteRange(backOffer, region, start, end));
        }
        return retryRanges;
    }

    private static Map<ByteString, ByteString> mapKeysToValues(List<ByteString> keys, List<ByteString> values) {
        HashMap<ByteString, ByteString> map = new HashMap<ByteString, ByteString>();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    private List<TiRegion> fetchRegionsFromRange(BackOffer backOffer, ByteString startKey, ByteString endKey) {
        ArrayList<TiRegion> regions = new ArrayList<TiRegion>();
        while (startKey.isEmpty() || endKey.isEmpty() || Key.toRawKey(startKey).compareTo(Key.toRawKey(endKey)) < 0) {
            TiRegion currentRegion = this.clientBuilder.getRegionManager().getRegionByKey(startKey, backOffer);
            regions.add(currentRegion);
            startKey = currentRegion.getEndKey();
            if (!currentRegion.getEndKey().isEmpty()) continue;
            break;
        }
        return regions;
    }

    private Iterator<Kvrpcpb.KvPair> rawScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, int limit, boolean keyOnly, BackOffer backOffer) {
        if (limit > 10240) {
            throw ERR_MAX_SCAN_LIMIT_EXCEEDED;
        }
        return new RawScanIterator(conf, builder, startKey, endKey, limit, keyOnly, backOffer);
    }

    public Iterator<Kvrpcpb.KvPair> scan0(ByteString startKey, ByteString endKey, int limit) {
        return this.scan0(startKey, endKey, limit, false);
    }

    public Iterator<Kvrpcpb.KvPair> scan0(ByteString startKey, int limit) {
        return this.scan0(startKey, limit, false);
    }

    public Iterator<Kvrpcpb.KvPair> scan0(ByteString startKey, int limit, boolean keyOnly) {
        return this.scan0(startKey, ByteString.EMPTY, limit, keyOnly);
    }

    public Iterator<Kvrpcpb.KvPair> scan0(ByteString startKey, ByteString endKey, int limit, boolean keyOnly) {
        String label = "client_raw_scan";
        Histogram.Timer requestTimer = ((Histogram.Child)RAW_REQUEST_LATENCY.labels(label)).startTimer();
        try {
            Iterator<Kvrpcpb.KvPair> iterator = this.rawScanIterator(this.conf, this.clientBuilder, startKey, endKey, limit, keyOnly, this.defaultBackOff());
            ((Counter.Child)RAW_REQUEST_SUCCESS.labels(label)).inc();
            Iterator<Kvrpcpb.KvPair> iterator2 = iterator;
            return iterator2;
        }
        catch (Exception e) {
            ((Counter.Child)RAW_REQUEST_FAILURE.labels(label)).inc();
            throw e;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    public Iterator<Kvrpcpb.KvPair> scan0(ByteString startKey, ByteString endKey) {
        return this.scan0(startKey, endKey, false);
    }

    private Iterator<Kvrpcpb.KvPair> scan0(ScanOption scanOption) {
        ByteString startKey = scanOption.getStartKey();
        ByteString endKey = scanOption.getEndKey();
        int limit = scanOption.getLimit();
        boolean keyOnly = scanOption.isKeyOnly();
        return this.scan0(startKey, endKey, limit, keyOnly);
    }

    public Iterator<Kvrpcpb.KvPair> scanPrefix0(ByteString prefixKey, int limit, boolean keyOnly) {
        return this.scan0(prefixKey, Key.toRawKey(prefixKey).nextPrefix().toByteString(), limit, keyOnly);
    }

    public Iterator<Kvrpcpb.KvPair> scanPrefix0(ByteString prefixKey) {
        return this.scan0(prefixKey, Key.toRawKey(prefixKey).nextPrefix().toByteString());
    }

    public Iterator<Kvrpcpb.KvPair> scanPrefix0(ByteString prefixKey, boolean keyOnly) {
        return this.scan0(prefixKey, Key.toRawKey(prefixKey).nextPrefix().toByteString(), keyOnly);
    }

    public Iterator<Kvrpcpb.KvPair> scan0(ByteString startKey, ByteString endKey, boolean keyOnly) {
        return new TikvIterator(startKey, endKey, keyOnly);
    }

    private BackOffer defaultBackOff() {
        return ConcreteBackOffer.newCustomBackOff(this.conf.getRawKVDefaultBackoffInMS());
    }

    public class TikvIterator
    implements Iterator<Kvrpcpb.KvPair> {
        private Iterator<Kvrpcpb.KvPair> iterator;
        private final ByteString startKey;
        private final ByteString endKey;
        private final boolean keyOnly;
        private Kvrpcpb.KvPair last;

        public TikvIterator(ByteString startKey, ByteString endKey, boolean keyOnly) {
            this.startKey = startKey;
            this.endKey = endKey;
            this.keyOnly = keyOnly;
            this.iterator = RawKVClient.this.rawScanIterator(RawKVClient.this.conf, RawKVClient.this.clientBuilder, this.startKey, this.endKey, RawKVClient.this.conf.getScanBatchSize(), keyOnly, RawKVClient.this.defaultBackOff());
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            if (this.last == null) {
                return false;
            }
            ByteString startKey = Key.toRawKey(this.last.getKey()).next().toByteString();
            this.iterator = RawKVClient.this.rawScanIterator(RawKVClient.this.conf, RawKVClient.this.clientBuilder, startKey, this.endKey, RawKVClient.this.conf.getScanBatchSize(), this.keyOnly, RawKVClient.this.defaultBackOff());
            this.last = null;
            return this.iterator.hasNext();
        }

        @Override
        public Kvrpcpb.KvPair next() {
            Kvrpcpb.KvPair next;
            this.last = next = this.iterator.next();
            return next;
        }
    }
}

