/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.importer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.TiConfiguration;
import org.tikv.common.TiSession;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.RegionException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.importer.ImporterStoreClient;
import org.tikv.common.key.Key;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.ImportSstpb;
import org.tikv.kvproto.Metapb;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.grpc.Status;
import org.tikv.shade.io.grpc.StatusRuntimeException;

public class ImporterClient {
    private static final Logger logger = LoggerFactory.getLogger(ImporterClient.class);
    private TiConfiguration tiConf;
    private TiSession tiSession;
    private ByteString uuid;
    private Key minKey;
    private Key maxKey;
    private TiRegion region;
    private Long ttl;
    private boolean deduplicate = false;
    private boolean streamOpened = false;
    private ImportSstpb.SSTMeta sstMeta;
    private List<ImporterStoreClient> clientList;
    private ImporterStoreClient clientLeader;

    public ImporterClient(TiSession tiSession, ByteString uuid, Key minKey, Key maxKey, TiRegion region, Long ttl) {
        this.uuid = uuid;
        this.tiConf = tiSession.getConf();
        this.tiSession = tiSession;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.region = region;
        this.ttl = ttl;
    }

    public boolean isDeduplicate() {
        return this.deduplicate;
    }

    public void setDeduplicate(boolean deduplicate) {
        this.deduplicate = deduplicate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(Iterator<Pair<ByteString, ByteString>> iterator) throws TiKVException {
        this.streamOpened = false;
        int maxKVBatchSize = this.tiConf.getImporterMaxKVBatchSize();
        int maxKVBatchBytes = this.tiConf.getImporterMaxKVBatchBytes();
        int totalBytes = 0;
        ByteString preKey = null;
        while (iterator.hasNext()) {
            ArrayList<ImportSstpb.Pair> pairs = new ArrayList<ImportSstpb.Pair>(maxKVBatchSize);
            for (int i = 0; i < maxKVBatchSize; ++i) {
                if (iterator.hasNext()) {
                    Pair<ByteString, ByteString> pair = iterator.next();
                    if (preKey != null && preKey.equals(pair.first)) {
                        if (!this.deduplicate) throw new TiKVException(String.format("duplicate key found, key = %s", preKey.toStringUtf8()));
                        logger.info("skip duplicate key: {}", (Object)preKey.toStringUtf8());
                    } else {
                        pairs.add(ImportSstpb.Pair.newBuilder().setKey((ByteString)pair.first).setValue((ByteString)pair.second).build());
                        totalBytes += ((ByteString)pair.first).size() + ((ByteString)pair.second).size();
                        preKey = (ByteString)pair.first;
                    }
                }
                if (totalBytes > maxKVBatchBytes || !iterator.hasNext()) break;
            }
            if (!this.streamOpened) {
                this.init();
                this.startWrite();
                this.writeMeta();
                this.streamOpened = true;
            }
            this.writeBatch(pairs);
            totalBytes = 0;
        }
        if (!this.streamOpened) return;
        this.finishWrite();
        this.ingest();
    }

    private void init() {
        long regionId = this.region.getId();
        Metapb.RegionEpoch regionEpoch = this.region.getRegionEpoch();
        ImportSstpb.Range range = this.tiConf.isTxnKVMode() ? ImportSstpb.Range.newBuilder().setStart(this.encode(this.minKey.toByteString())).setEnd(this.encode(this.maxKey.toByteString())).build() : ImportSstpb.Range.newBuilder().setStart(this.minKey.toByteString()).setEnd(this.maxKey.toByteString()).build();
        this.sstMeta = ImportSstpb.SSTMeta.newBuilder().setUuid(this.uuid).setRegionId(regionId).setRegionEpoch(regionEpoch).setRange(range).build();
        this.clientList = new ArrayList<ImporterStoreClient>();
        for (Metapb.Peer peer : this.region.getPeersList()) {
            long storeId = peer.getStoreId();
            TiStore store = this.tiSession.getRegionManager().getStoreById(storeId);
            ImporterStoreClient importerStoreClient = this.tiSession.getImporterRegionStoreClientBuilder().build(store);
            this.clientList.add(importerStoreClient);
            if (this.region.getLeader().getStoreId() != storeId) continue;
            this.clientLeader = importerStoreClient;
        }
    }

    private ByteString encode(ByteString key) {
        CodecDataOutput cdo = new CodecDataOutput();
        Codec.BytesCodec.writeBytes(cdo, key.toByteArray());
        return cdo.toByteString();
    }

    private void startWrite() {
        for (ImporterStoreClient client : this.clientList) {
            client.startWrite();
        }
    }

    private void writeMeta() {
        if (this.tiConf.isTxnKVMode()) {
            ImportSstpb.WriteRequest request = ImportSstpb.WriteRequest.newBuilder().setMeta(this.sstMeta).build();
            for (ImporterStoreClient client : this.clientList) {
                client.writeBatch(request);
            }
        } else {
            ImportSstpb.RawWriteRequest request = ImportSstpb.RawWriteRequest.newBuilder().setMeta(this.sstMeta).build();
            for (ImporterStoreClient client : this.clientList) {
                client.writeBatch(request);
            }
        }
    }

    private void writeBatch(List<ImportSstpb.Pair> pairs) {
        if (this.tiConf.isTxnKVMode()) {
            ImportSstpb.WriteBatch batch = ImportSstpb.WriteBatch.newBuilder().addAllPairs(pairs).setCommitTs(this.tiSession.getTimestamp().getVersion()).build();
            ImportSstpb.WriteRequest request = ImportSstpb.WriteRequest.newBuilder().setBatch(batch).build();
            for (ImporterStoreClient client : this.clientList) {
                client.writeBatch(request);
            }
        } else {
            ImportSstpb.RawWriteBatch batch = this.ttl == null || this.ttl <= 0L ? ImportSstpb.RawWriteBatch.newBuilder().addAllPairs(pairs).build() : ImportSstpb.RawWriteBatch.newBuilder().addAllPairs(pairs).setTtl(this.ttl).build();
            ImportSstpb.RawWriteRequest request = ImportSstpb.RawWriteRequest.newBuilder().setBatch(batch).build();
            for (ImporterStoreClient client : this.clientList) {
                client.writeBatch(request);
            }
        }
    }

    private void finishWrite() {
        for (ImporterStoreClient client : this.clientList) {
            client.finishWrite();
        }
    }

    private void ingest() throws GrpcException {
        ArrayList<ImporterStoreClient> workingClients = new ArrayList<ImporterStoreClient>(this.clientList);
        while (!workingClients.isEmpty()) {
            Iterator itor = workingClients.iterator();
            while (itor.hasNext()) {
                ImporterStoreClient client = (ImporterStoreClient)itor.next();
                if (client.isWriteResponseReceived()) {
                    itor.remove();
                    continue;
                }
                if (!client.hasWriteResponseError()) continue;
                throw new GrpcException(client.getWriteError());
            }
            if (workingClients.isEmpty()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Object writeResponse = this.clientLeader.getWriteResponse();
        ConcreteBackOffer backOffer = ConcreteBackOffer.newCustomBackOff(30000);
        this.ingestWithRetry(writeResponse, backOffer);
    }

    private void ingestWithRetry(Object writeResponse, BackOffer backOffer) {
        try {
            this.clientLeader.multiIngest(this.region.getLeaderContext(), writeResponse);
        }
        catch (RegionException e) {
            logger.warn("ingest failed.", (Throwable)e);
            boolean retry = false;
            Errorpb.Error error = e.getRegionErr();
            if (error != null) {
                if (error.hasNotLeader()) {
                    BackOffFunction.BackOffFuncType backOffFuncType;
                    retry = true;
                    long newStoreId = error.getNotLeader().getLeader().getStoreId();
                    logger.warn(String.format("NotLeader Error with region id %d and store id %d, new store id %d", this.region.getId(), this.region.getLeader().getStoreId(), newStoreId));
                    if (newStoreId != 0L) {
                        long regionId = this.region.getId();
                        this.region = this.tiSession.getRegionManager().updateLeader(this.region, newStoreId);
                        if (this.region == null) {
                            this.region = this.tiSession.getRegionManager().getRegionById(regionId);
                        }
                        backOffFuncType = BackOffFunction.BackOffFuncType.BoUpdateLeader;
                    } else {
                        logger.info(String.format("Received zero store id, from region %d try next time", this.region.getId()));
                        this.tiSession.getRegionManager().invalidateRegion(this.region);
                        this.region = this.tiSession.getRegionManager().getRegionById(this.region.getId());
                        backOffFuncType = BackOffFunction.BackOffFuncType.BoRegionMiss;
                    }
                    backOffer.doBackOff(backOffFuncType, e);
                    this.init();
                } else if (error.hasServerIsBusy()) {
                    retry = true;
                    logger.warn(String.format("Server is busy for region [%s], reason: %s", this.region, error.getServerIsBusy().getReason()));
                    backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoServerBusy, new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString())));
                } else {
                    this.tiSession.getRegionManager().invalidateRegion(this.region);
                }
            }
            if (retry) {
                this.ingestWithRetry(writeResponse, backOffer);
            }
            throw e;
        }
    }
}

