/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.util.List;
import java.util.Objects;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.Visitor;
import org.tikv.common.types.IntegerType;
import org.tikv.shade.com.google.common.collect.ImmutableList;

public class IsNull
extends Expression {
    private final Expression expression;

    public IsNull(Expression expression) {
        super(IntegerType.BOOLEAN);
        this.resolved = true;
        this.expression = Objects.requireNonNull(expression, "expression is null");
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.expression);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public String toString() {
        return String.format("IsNull(%s)", this.getExpression());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IsNull)) {
            return false;
        }
        IsNull that = (IsNull)other;
        return Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hashCode(this.expression);
    }
}

