/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlite;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlite.SqliteJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.sqlite.SqliteTypeMapper;

public class SqliteDialect
implements JdbcDialect {
    @Override
    public String dialectName() {
        return "Sqlite";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new SqliteJdbcRowConverter();
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new SqliteTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String updateClause = Arrays.stream(fieldNames).map(fieldName -> this.quoteIdentifier((String)fieldName) + "=VALUES(" + this.quoteIdentifier((String)fieldName) + ")").collect(Collectors.joining(", "));
        String conflictFields = Arrays.stream(uniqueKeyFields).map(this::quoteIdentifier).collect(Collectors.joining(","));
        String upsertSQL = this.getInsertIntoStatement(database, tableName, fieldNames) + " ON CONFLICT(" + conflictFields + ") DO UPDATE SET " + updateClause;
        return Optional.of(upsertSQL);
    }
}

