/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.BasicTypeDefine;
import org.apache.seatunnel.connectors.seatunnel.common.source.TypeDefineUtils;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.oracle.OracleTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleTypeMapper
implements JdbcDialectTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(OracleTypeMapper.class);
    private final boolean decimalTypeNarrowing;

    public OracleTypeMapper() {
        this((Boolean)JdbcOptions.DECIMAL_TYPE_NARROWING.defaultValue());
    }

    public OracleTypeMapper(boolean decimalTypeNarrowing) {
        this.decimalTypeNarrowing = decimalTypeNarrowing;
    }

    @Override
    public Column mappingColumn(BasicTypeDefine typeDefine) {
        return new OracleTypeConverter(this.decimalTypeNarrowing).convert(typeDefine);
    }

    @Override
    public Column mappingColumn(ResultSetMetaData metadata, int colIndex) throws SQLException {
        String columnName = metadata.getColumnLabel(colIndex);
        String nativeType = metadata.getColumnTypeName(colIndex);
        int isNullable = metadata.isNullable(colIndex);
        long precision = metadata.getPrecision(colIndex);
        int scale = metadata.getScale(colIndex);
        if ("number".equalsIgnoreCase(nativeType) && scale == -127) {
            nativeType = "float";
        } else if (Arrays.asList("NVARCHAR2", "NCHAR").contains(nativeType)) {
            long doubleByteLength;
            precision = doubleByteLength = TypeDefineUtils.charToDoubleByteLength(precision).longValue();
        }
        BasicTypeDefine typeDefine = BasicTypeDefine.builder().name(columnName).columnType(nativeType).dataType(nativeType).nullable(isNullable == 1).length(Long.valueOf(precision)).precision(Long.valueOf(precision)).scale(Integer.valueOf(scale)).build();
        return this.mappingColumn(typeDefine);
    }
}

