/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.dialectenum.FieldIdeEnum;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisJdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.iris.IrisTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceTable;

public class IrisDialect
implements JdbcDialect {
    private static final Integer DEFAULT_IRIS_FETCH_SIZE = 500;
    private String fieldIde = FieldIdeEnum.ORIGINAL.getValue();

    public IrisDialect() {
    }

    public IrisDialect(String fieldIde) {
        this.fieldIde = fieldIde;
    }

    @Override
    public String dialectName() {
        return "IRIS";
    }

    @Override
    public JdbcRowConverter getRowConverter() {
        return new IrisJdbcRowConverter();
    }

    @Override
    public String hashModForField(String fieldName, int mod) {
        throw new SeaTunnelException("The iris database is not supported hash or md5 function. Please remove the partition_column property in config.");
    }

    @Override
    public JdbcDialectTypeMapper getJdbcDialectTypeMapper() {
        return new IrisTypeMapper();
    }

    @Override
    public String quoteIdentifier(String identifier) {
        if (identifier.contains(".")) {
            String[] parts = identifier.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.length - 1; ++i) {
                sb.append("\"").append(parts[i]).append("\"").append(".");
            }
            return sb.append("\"").append(this.getFieldIde(parts[parts.length - 1], this.fieldIde)).append("\"").toString();
        }
        return "\"" + this.getFieldIde(identifier, this.fieldIde) + "\"";
    }

    @Override
    public String tableIdentifier(String database, String tableName) {
        return this.quoteIdentifier(tableName);
    }

    @Override
    public String extractTableName(TablePath tablePath) {
        return tablePath.getSchemaAndTableName();
    }

    @Override
    public TablePath parse(String tablePath) {
        return TablePath.of((String)tablePath, (boolean)true);
    }

    @Override
    public String tableIdentifier(TablePath tablePath) {
        return this.quoteIdentifier(tablePath.getSchemaAndTableName());
    }

    @Override
    public Optional<String> getUpsertStatement(String database, String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String insertIntoStatement = this.getInsertIntoStatement(database, tableName, fieldNames);
        return Optional.of(insertIntoStatement);
    }

    @Override
    public String getInsertIntoStatement(String database, String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(fieldName -> ":" + fieldName).collect(Collectors.joining(", "));
        return String.format("INSERT OR UPDATE %s (%s) VALUES (%s)", this.tableIdentifier(database, tableName), columns, placeholders);
    }

    @Override
    public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        } else {
            statement.setFetchSize(DEFAULT_IRIS_FETCH_SIZE);
        }
        return statement;
    }

    @Override
    public Object queryNextChunkMax(Connection connection, JdbcSourceTable table, String columnName, int chunkSize, Object includedLowerBound) throws SQLException {
        String quotedColumn = this.quoteIdentifier(columnName);
        String sqlQuery = StringUtils.isNotBlank(table.getQuery()) ? String.format("SELECT MAX(%s) FROM (SELECT TOP %s %s FROM (%s) WHERE %s >= ? ORDER BY %s ASC )", quotedColumn, chunkSize, quotedColumn, table.getQuery(), quotedColumn, quotedColumn) : String.format("SELECT MAX(%s) FROM (SELECT TOP %s %s FROM (%s) WHERE %s >= ? ORDER BY %s ASC )", quotedColumn, chunkSize, quotedColumn, this.tableIdentifier(table.getTablePath()), quotedColumn, quotedColumn);
        try (PreparedStatement ps = connection.prepareStatement(sqlQuery);){
            Object object;
            block13: {
                ps.setObject(1, includedLowerBound);
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new SQLException(String.format("No result returned after running query [%s]", sqlQuery));
                    }
                    object = rs.getObject(1);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return object;
        }
    }

    @Override
    public ResultSetMetaData getResultSetMetaData(Connection conn, String query) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement(query);){
            ResultSetMetaData resultSetMetaData;
            block12: {
                ResultSet resultSet = ps.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return resultSetMetaData;
        }
    }
}

