/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceTableConfig;

public interface JdbcSourceOptions {
    public static final Option<String> TABLE_PATH = Options.key((String)"table_path").stringType().noDefaultValue().withDescription("table full path");
    public static final Option<String> WHERE_CONDITION = Options.key((String)"where_condition").stringType().noDefaultValue().withDescription("Common row filter conditions for all tables/queries, must start with `where`. for example `where id > 100`");
    public static final Option<List<JdbcSourceTableConfig>> TABLE_LIST = Options.key((String)"table_list").listType(JdbcSourceTableConfig.class).noDefaultValue().withDescription("table list config");
    public static final Option<Integer> SPLIT_SIZE = Options.key((String)"split.size").intType().defaultValue((Object)8096).withDescription("The split size (number of rows) of table snapshot, captured tables are split into multiple splits when read     of table.");
    public static final Option<Double> SPLIT_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = Options.key((String)"split.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)100.0).withDescription("The upper bound of split key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final Option<Double> SPLIT_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = Options.key((String)"split.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withDescription("The lower bound of split key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    public static final Option<Integer> SPLIT_SAMPLE_SHARDING_THRESHOLD = Options.key((String)"split.sample-sharding.threshold").intType().defaultValue((Object)1000).withDescription("The threshold of estimated shard count to trigger the sample sharding strategy. When the distribution factor is outside the upper and lower bounds, and if the estimated shard count (approximateRowCnt/chunkSize) exceeds this threshold, the sample sharding strategy will be used. This strategy can help to handle large datasets more efficiently. The default value is 1000 shards.");
    public static final Option<Integer> SPLIT_INVERSE_SAMPLING_RATE = Options.key((String)"split.inverse-sampling.rate").intType().defaultValue((Object)1000).withDescription("The inverse of the sampling rate for the sample sharding strategy. The value represents the denominator of the sampling rate fraction. For example, a value of 1000 means a sampling rate of 1/1000. This parameter is used when the sample sharding strategy is triggered.");
    public static final Option<Boolean> USE_SELECT_COUNT = Options.key((String)"use_select_count").booleanType().defaultValue((Object)false).withDescription("Use select count for table count");
    public static final Option<Boolean> SKIP_ANALYZE = Options.key((String)"skip_analyze").booleanType().defaultValue((Object)false).withDescription("Skip the analysis of table count");
}

