/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.snowflake;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

@AutoService(value={DataTypeConvertor.class})
public class SnowflakeDataTypeConvertor
implements DataTypeConvertor<String> {
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final Integer DEFAULT_PRECISION = 10;
    public static final Integer DEFAULT_SCALE = 0;
    private static final String SNOWFLAKE_NUMBER = "NUMBER";
    private static final String SNOWFLAKE_DECIMAL = "DECIMAL";
    private static final String SNOWFLAKE_NUMERIC = "NUMERIC";
    private static final String SNOWFLAKE_INT = "INT";
    private static final String SNOWFLAKE_INTEGER = "INTEGER";
    private static final String SNOWFLAKE_BIGINT = "BIGINT";
    private static final String SNOWFLAKE_SMALLINT = "SMALLINT";
    private static final String SNOWFLAKE_TINYINT = "TINYINT";
    private static final String SNOWFLAKE_BYTEINT = "BYTEINT";
    private static final String SNOWFLAKE_FLOAT = "FLOAT";
    private static final String SNOWFLAKE_FLOAT4 = "FLOAT4";
    private static final String SNOWFLAKE_FLOAT8 = "FLOAT8";
    private static final String SNOWFLAKE_DOUBLE = "DOUBLE";
    private static final String SNOWFLAKE_DOUBLE_PRECISION = "DOUBLE PRECISION";
    private static final String SNOWFLAKE_REAL = "REAL";
    private static final String SNOWFLAKE_VARCHAR = "VARCHAR";
    private static final String SNOWFLAKE_CHAR = "CHAR";
    private static final String SNOWFLAKE_CHARACTER = "CHARACTER";
    private static final String SNOWFLAKE_STRING = "STRING";
    private static final String SNOWFLAKE_TEXT = "TEXT";
    private static final String SNOWFLAKE_BINARY = "BINARY";
    private static final String SNOWFLAKE_VARBINARY = "VARBINARY";
    private static final String SNOWFLAKE_BOOLEAN = "BOOLEAN";
    private static final String SNOWFLAKE_DATE = "DATE";
    private static final String SNOWFLAKE_DATE_TIME = "DATE_TIME";
    private static final String SNOWFLAKE_TIME = "TIME";
    private static final String SNOWFLAKE_TIMESTAMP = "TIMESTAMP";
    private static final String SNOWFLAKE_TIMESTAMP_LTZ = "TIMESTAMP_LTZ";
    private static final String SNOWFLAKE_TIMESTAMP_NTZ = "TIMESTAMP_NTZ";
    private static final String SNOWFLAKE_TIMESTAMP_TZ = "TIMESTAMP_TZ";
    private static final String SNOWFLAKE_GEOGRAPHY = "GEOGRAPHY";
    private static final String SNOWFLAKE_GEOMETRY = "GEOMETRY";
    private static final String SNOWFLAKE_VARIANT = "VARIANT";
    private static final String SNOWFLAKE_OBJECT = "OBJECT";

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType) {
        return this.toSeaTunnelType(field, connectorDataType, Collections.emptyMap());
    }

    public SeaTunnelDataType<?> toSeaTunnelType(String field, String connectorDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull((Object)connectorDataType, (Object)"redshiftType cannot be null");
        switch (connectorDataType) {
            case "SMALLINT": 
            case "TINYINT": 
            case "BYTEINT": {
                return BasicType.SHORT_TYPE;
            }
            case "INTEGER": 
            case "INT": {
                return BasicType.INT_TYPE;
            }
            case "BIGINT": {
                return BasicType.LONG_TYPE;
            }
            case "DECIMAL": 
            case "NUMERIC": 
            case "NUMBER": {
                Integer precision = MapUtils.getInteger(dataTypeProperties, (Object)PRECISION, (Integer)DEFAULT_PRECISION);
                Integer scale = MapUtils.getInteger(dataTypeProperties, (Object)SCALE, (Integer)DEFAULT_SCALE);
                return new DecimalType(precision.intValue(), scale.intValue());
            }
            case "REAL": 
            case "FLOAT4": {
                return BasicType.FLOAT_TYPE;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "FLOAT8": 
            case "FLOAT": {
                return BasicType.DOUBLE_TYPE;
            }
            case "BOOLEAN": {
                return BasicType.BOOLEAN_TYPE;
            }
            case "CHAR": 
            case "CHARACTER": 
            case "VARCHAR": 
            case "STRING": 
            case "TEXT": 
            case "VARIANT": 
            case "OBJECT": 
            case "GEOMETRY": {
                return BasicType.STRING_TYPE;
            }
            case "BINARY": 
            case "VARBINARY": 
            case "GEOGRAPHY": {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case "DATE": {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case "TIME": {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case "DATE_TIME": 
            case "TIMESTAMP": 
            case "TIMESTAMP_LTZ": 
            case "TIMESTAMP_NTZ": 
            case "TIMESTAMP_TZ": {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError((String)"Snowflake", (String)connectorDataType, (String)field);
    }

    public String toConnectorType(String field, SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) {
        Preconditions.checkNotNull(seaTunnelDataType, (Object)"seaTunnelDataType cannot be null");
        SqlType sqlType = seaTunnelDataType.getSqlType();
        switch (sqlType) {
            case TINYINT: 
            case SMALLINT: {
                return SNOWFLAKE_SMALLINT;
            }
            case INT: {
                return SNOWFLAKE_INTEGER;
            }
            case BIGINT: {
                return SNOWFLAKE_BIGINT;
            }
            case DECIMAL: {
                return SNOWFLAKE_DECIMAL;
            }
            case FLOAT: {
                return SNOWFLAKE_FLOAT4;
            }
            case DOUBLE: {
                return SNOWFLAKE_DOUBLE_PRECISION;
            }
            case BOOLEAN: {
                return SNOWFLAKE_BOOLEAN;
            }
            case STRING: {
                return SNOWFLAKE_TEXT;
            }
            case DATE: {
                return SNOWFLAKE_DATE;
            }
            case BYTES: {
                return SNOWFLAKE_GEOMETRY;
            }
            case TIME: {
                return SNOWFLAKE_TIME;
            }
            case TIMESTAMP: {
                return SNOWFLAKE_TIMESTAMP;
            }
        }
        throw CommonError.convertToSeaTunnelTypeError((String)"Snowflake", (String)seaTunnelDataType.getSqlType().toString(), (String)field);
    }

    public String getIdentity() {
        return "Snowflake";
    }
}

