/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset;

import io.debezium.connector.mysql.GtidSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;

public class BinlogOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final String BINLOG_FILENAME_OFFSET_KEY = "file";
    public static final String BINLOG_POSITION_OFFSET_KEY = "pos";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String ROWS_TO_SKIP_OFFSET_KEY = "row";
    public static final String GTID_SET_KEY = "gtids";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String SERVER_ID_KEY = "server_id";
    public static final BinlogOffset INITIAL_OFFSET = new BinlogOffset("", 0L);
    public static final BinlogOffset NO_STOPPING_OFFSET = new BinlogOffset("", Long.MIN_VALUE);

    public BinlogOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public BinlogOffset(String filename, long position) {
        this(filename, position, 0L, 0L, 0L, null, null);
    }

    public BinlogOffset(String filename, long position, long restartSkipEvents, long restartSkipRows, long binlogEpochSecs, String restartGtidSet, Integer serverId) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put(BINLOG_FILENAME_OFFSET_KEY, filename);
        offsetMap.put(BINLOG_POSITION_OFFSET_KEY, String.valueOf(position));
        offsetMap.put(EVENTS_TO_SKIP_OFFSET_KEY, String.valueOf(restartSkipEvents));
        offsetMap.put(ROWS_TO_SKIP_OFFSET_KEY, String.valueOf(restartSkipRows));
        offsetMap.put(TIMESTAMP_KEY, String.valueOf(binlogEpochSecs));
        if (restartGtidSet != null) {
            offsetMap.put(GTID_SET_KEY, restartGtidSet);
        }
        if (serverId != null) {
            offsetMap.put(SERVER_ID_KEY, String.valueOf(serverId));
        }
        this.offset = offsetMap;
    }

    public String getFilename() {
        return (String)this.offset.get(BINLOG_FILENAME_OFFSET_KEY);
    }

    public long getPosition() {
        return this.longOffsetValue(this.offset, BINLOG_POSITION_OFFSET_KEY);
    }

    public long getRestartSkipEvents() {
        return this.longOffsetValue(this.offset, EVENTS_TO_SKIP_OFFSET_KEY);
    }

    public long getRestartSkipRows() {
        return this.longOffsetValue(this.offset, ROWS_TO_SKIP_OFFSET_KEY);
    }

    public String getGtidSet() {
        return (String)this.offset.get(GTID_SET_KEY);
    }

    public long getTimestamp() {
        return this.longOffsetValue(this.offset, TIMESTAMP_KEY);
    }

    public Long getServerId() {
        return this.longOffsetValue(this.offset, SERVER_ID_KEY);
    }

    @Override
    public int compareTo(Offset offset) {
        long targetServerId;
        BinlogOffset that = (BinlogOffset)offset;
        if (NO_STOPPING_OFFSET.equals(that) && NO_STOPPING_OFFSET.equals(this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals(this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals(that)) {
            return -1;
        }
        String gtidSetStr = this.getGtidSet();
        String targetGtidSetStr = that.getGtidSet();
        if (StringUtils.isNotEmpty(targetGtidSetStr)) {
            if (StringUtils.isNotEmpty(gtidSetStr)) {
                GtidSet gtidSet = new GtidSet(gtidSetStr);
                GtidSet targetGtidSet = new GtidSet(targetGtidSetStr);
                if (gtidSet.equals(targetGtidSet)) {
                    long restartSkipEvents = this.getRestartSkipEvents();
                    long targetRestartSkipEvents = that.getRestartSkipEvents();
                    return Long.compare(restartSkipEvents, targetRestartSkipEvents);
                }
                return gtidSet.isContainedWithin(targetGtidSet) ? -1 : 1;
            }
            return -1;
        }
        if (StringUtils.isNotEmpty(gtidSetStr)) {
            return 1;
        }
        long serverId = this.getServerId();
        if (serverId != (targetServerId = that.getServerId().longValue())) {
            long timestamp = this.getTimestamp();
            long targetTimestamp = that.getTimestamp();
            if (timestamp != 0L && targetTimestamp != 0L) {
                return Long.compare(timestamp, targetTimestamp);
            }
        }
        if (this.getFilename().compareToIgnoreCase(that.getFilename()) != 0) {
            return this.getFilename().compareToIgnoreCase(that.getFilename());
        }
        if (this.getPosition() != that.getPosition()) {
            return Long.compare(this.getPosition(), that.getPosition());
        }
        if (this.getRestartSkipEvents() != that.getRestartSkipEvents()) {
            return Long.compare(this.getRestartSkipEvents(), that.getRestartSkipEvents());
        }
        return Long.compare(this.getRestartSkipRows(), that.getRestartSkipRows());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinlogOffset)) {
            return false;
        }
        BinlogOffset that = (BinlogOffset)o;
        return this.offset.equals(that.offset);
    }
}

