/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.source.SupportSchemaEvolution;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.schema.SchemaChangeType;
import org.apache.seatunnel.common.utils.JdbcUrlUtil;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.config.JdbcSourceConfig;
import org.apache.seatunnel.connectors.cdc.base.config.SourceConfig;
import org.apache.seatunnel.connectors.cdc.base.dialect.DataSourceDialect;
import org.apache.seatunnel.connectors.cdc.base.option.JdbcSourceOptions;
import org.apache.seatunnel.connectors.cdc.base.option.StartupMode;
import org.apache.seatunnel.connectors.cdc.base.option.StopMode;
import org.apache.seatunnel.connectors.cdc.base.source.IncrementalSource;
import org.apache.seatunnel.connectors.cdc.base.source.offset.OffsetFactory;
import org.apache.seatunnel.connectors.cdc.debezium.ConnectTableChangeSerializer;
import org.apache.seatunnel.connectors.cdc.debezium.DebeziumDeserializationSchema;
import org.apache.seatunnel.connectors.cdc.debezium.DeserializeFormat;
import org.apache.seatunnel.connectors.cdc.debezium.row.DebeziumJsonDeserializeSchema;
import org.apache.seatunnel.connectors.cdc.debezium.row.SeaTunnelRowDebeziumDeserializeSchema;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config.MySqlSourceConfigFactory;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.MySqlDialect;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.MySqlSchemaChangeResolver;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.MySqlSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.cdc.mysql.source.offset.BinlogOffsetFactory;
import org.apache.seatunnel.connectors.seatunnel.jdbc.catalog.JdbcCatalogOptions;

public class MySqlIncrementalSource<T>
extends IncrementalSource<T, JdbcSourceConfig>
implements SupportParallelism,
SupportSchemaEvolution {
    static final String IDENTIFIER = "MySQL-CDC";

    public MySqlIncrementalSource(ReadonlyConfig options, List<CatalogTable> catalogTables) {
        super(options, catalogTables);
    }

    @Override
    public Option<StartupMode> getStartupModeOption() {
        return MySqlSourceOptions.STARTUP_MODE;
    }

    @Override
    public Option<StopMode> getStopModeOption() {
        return MySqlSourceOptions.STOP_MODE;
    }

    public String getPluginName() {
        return IDENTIFIER;
    }

    @Override
    public SourceConfig.Factory<JdbcSourceConfig> createSourceConfigFactory(ReadonlyConfig config) {
        MySqlSourceConfigFactory configFactory = new MySqlSourceConfigFactory();
        configFactory.serverId((String)config.get(JdbcSourceOptions.SERVER_ID));
        configFactory.fromReadonlyConfig(this.readonlyConfig);
        JdbcUrlUtil.UrlInfo urlInfo = JdbcUrlUtil.getUrlInfo((String)((String)config.get(JdbcCatalogOptions.BASE_URL)));
        configFactory.originUrl(urlInfo.getOrigin());
        configFactory.hostname(urlInfo.getHost());
        configFactory.port(urlInfo.getPort());
        configFactory.startupOptions(this.startupConfig);
        configFactory.stopOptions(this.stopConfig);
        return configFactory;
    }

    @Override
    public DebeziumDeserializationSchema<T> createDebeziumDeserializationSchema(ReadonlyConfig config) {
        Map<TableId, Struct> tableIdTableChangeMap = this.tableChanges();
        if (DeserializeFormat.COMPATIBLE_DEBEZIUM_JSON.equals(config.get(JdbcSourceOptions.FORMAT))) {
            return new DebeziumJsonDeserializeSchema((Map)config.get(JdbcSourceOptions.DEBEZIUM_PROPERTIES), tableIdTableChangeMap);
        }
        String zoneId = (String)config.get(JdbcSourceOptions.SERVER_TIME_ZONE);
        return SeaTunnelRowDebeziumDeserializeSchema.builder().setTables(this.catalogTables).setServerTimeZone(ZoneId.of(zoneId)).setTableIdTableChangeMap(tableIdTableChangeMap).setSchemaChangeResolver(new MySqlSchemaChangeResolver(this.createSourceConfigFactory(config))).build();
    }

    @Override
    public DataSourceDialect<JdbcSourceConfig> createDataSourceDialect(ReadonlyConfig config) {
        return new MySqlDialect((MySqlSourceConfigFactory)this.configFactory, this.catalogTables);
    }

    @Override
    public OffsetFactory createOffsetFactory(ReadonlyConfig config) {
        return new BinlogOffsetFactory((MySqlSourceConfigFactory)this.configFactory, (MySqlDialect)this.dataSourceDialect);
    }

    private Map<TableId, Struct> tableChanges() {
        Map<TableId, Struct> map;
        block8: {
            JdbcSourceConfig jdbcSourceConfig = (JdbcSourceConfig)this.configFactory.create(0);
            MySqlDialect mySqlDialect = new MySqlDialect((MySqlSourceConfigFactory)this.configFactory, this.catalogTables);
            List<TableId> discoverTables = mySqlDialect.discoverDataCollections(jdbcSourceConfig);
            ConnectTableChangeSerializer connectTableChangeSerializer = new ConnectTableChangeSerializer();
            JdbcConnection jdbcConnection = mySqlDialect.openJdbcConnection(jdbcSourceConfig);
            try {
                map = discoverTables.stream().collect(Collectors.toMap(Function.identity(), tableId -> {
                    TableChanges tableChanges = new TableChanges();
                    tableChanges.create(mySqlDialect.queryTableSchema(jdbcConnection, (TableId)tableId).getTable());
                    return (Struct)connectTableChangeSerializer.serialize(tableChanges).get(0);
                }));
                if (jdbcConnection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcConnection != null) {
                        try {
                            jdbcConnection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SeaTunnelException((Throwable)e);
                }
            }
            jdbcConnection.close();
        }
        return map;
    }

    public List<SchemaChangeType> supports() {
        return Arrays.asList(SchemaChangeType.ADD_COLUMN, SchemaChangeType.DROP_COLUMN, SchemaChangeType.RENAME_COLUMN, SchemaChangeType.UPDATE_COLUMN);
    }
}

