/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mysql.config;

import java.io.Serializable;
import java.util.Random;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;

public class ServerIdRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long startServerId;
    private final long endServerId;

    public ServerIdRange(long startServerId, long endServerId) {
        this.startServerId = startServerId;
        this.endServerId = endServerId;
    }

    public long getStartServerId() {
        return this.startServerId;
    }

    public long getEndServerId() {
        return this.endServerId;
    }

    public long getServerId(int subTaskId) {
        Preconditions.checkArgument((subTaskId >= 0 ? 1 : 0) != 0, (String)"Subtask ID %s shouldn't be a negative number.", (int)subTaskId);
        if ((long)subTaskId > this.getNumberOfServerIds()) {
            throw new IllegalArgumentException(String.format("Subtask ID %s is out of server id range %s, please adjust the server id range to make the number of server id larger than the source parallelism.", subTaskId, this));
        }
        return this.startServerId + (long)subTaskId;
    }

    public long getNumberOfServerIds() {
        return this.endServerId - this.startServerId + 1L;
    }

    public String toString() {
        if (this.startServerId == this.endServerId) {
            return String.valueOf(this.startServerId);
        }
        return this.startServerId + "-" + this.endServerId;
    }

    public static ServerIdRange from(String range) {
        if (range == null) {
            long start = (long)new Random().nextInt(Integer.MAX_VALUE) + 6500L;
            long end = start + 1024000L;
            return new ServerIdRange(start, end);
        }
        if (range.contains("-")) {
            String[] idArray = range.split("-");
            if (idArray.length != 2) {
                throw new IllegalArgumentException(String.format("The server id range should be syntax like '5400-5500', but got: %s", range));
            }
            return new ServerIdRange(ServerIdRange.parseServerId(idArray[0].trim()), ServerIdRange.parseServerId(idArray[1].trim()));
        }
        long serverId = ServerIdRange.parseServerId(range);
        return new ServerIdRange(serverId, serverId);
    }

    private static long parseServerId(String serverIdValue) {
        try {
            return Long.parseLong(serverIdValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("The server id %s is not a valid numeric.", serverIdValue), e);
        }
    }
}

