/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.config.ConfigurationDefaults;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.legacy.Reader;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingReader
implements Reader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Consumer<MySqlPartition>> uponCompletion = new AtomicReference();
    private final AtomicReference<MySqlPartition> partition = new AtomicReference();
    private final AtomicReference<Reader.State> state = new AtomicReference();
    private final Metronome metronome;
    private final String name;
    private final String runningLogMessage;

    public BlockingReader(String name, String runningLogMessage) {
        this.name = name;
        this.metronome = Metronome.parker(ConfigurationDefaults.RETURN_CONTROL_INTERVAL, Clock.SYSTEM);
        this.runningLogMessage = runningLogMessage;
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        if (this.state.get() == Reader.State.STOPPED) {
            return null;
        }
        this.metronome.pause();
        this.state.compareAndSet(Reader.State.RUNNING, Reader.State.STOPPING);
        return null;
    }

    @Override
    public Reader.State state() {
        return this.state.get();
    }

    @Override
    public void uponCompletion(Consumer<MySqlPartition> handler) {
        assert (this.uponCompletion.get() == null);
        this.uponCompletion.set(handler);
    }

    @Override
    public void start(MySqlPartition partition) {
        this.state.set(Reader.State.RUNNING);
        this.logger.info(this.runningLogMessage);
    }

    @Override
    public void stop() {
        try {
            this.state.set(Reader.State.STOPPED);
            Consumer completionHandler = this.uponCompletion.getAndSet(null);
            if (completionHandler != null) {
                completionHandler.accept(this.partition.get());
            }
        }
        finally {
            this.logger.info("Blocking Reader has completed.");
        }
    }

    @Override
    public String name() {
        return this.name;
    }
}

