/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.utils;

import org.apache.rocketmq.schema.registry.common.context.RequestContext;
import org.apache.rocketmq.schema.registry.common.context.StorageServiceContext;
import org.apache.rocketmq.schema.registry.common.dto.AuditDto;
import org.apache.rocketmq.schema.registry.common.dto.Field;
import org.apache.rocketmq.schema.registry.common.dto.SchemaDetailDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaMetaDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaRecordDto;
import org.apache.rocketmq.schema.registry.common.dto.SchemaStorageDto;
import org.apache.rocketmq.schema.registry.common.dto.SubjectDto;
import org.apache.rocketmq.schema.registry.common.model.AuditInfo;
import org.apache.rocketmq.schema.registry.common.model.FieldInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaDetailInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaMetaInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaRecordInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaStorageInfo;
import org.apache.rocketmq.schema.registry.common.model.SubjectInfo;
import org.apache.rocketmq.schema.registry.common.utils.CommonUtil;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.api.TypeMappingOption;

public class StorageUtil {
    private final Mapper mapper;

    public StorageUtil() {
        DozerBeanMapper dozerBeanMapper = new DozerBeanMapper();
        BeanMappingBuilder builder = new BeanMappingBuilder(){

            protected void configure() {
                this.mapping(SchemaDto.class, SchemaInfo.class, new TypeMappingOption[0]);
                this.mapping(SchemaMetaDto.class, SchemaMetaInfo.class, new TypeMappingOption[0]);
                this.mapping(SchemaDetailDto.class, SchemaDetailInfo.class, new TypeMappingOption[0]);
                this.mapping(SchemaStorageDto.class, SchemaStorageInfo.class, new TypeMappingOption[0]);
                this.mapping(SchemaRecordDto.class, SchemaRecordInfo.class, new TypeMappingOption[0]);
                this.mapping(SubjectDto.class, SubjectInfo.class, new TypeMappingOption[0]);
                this.mapping(AuditDto.class, AuditInfo.class, new TypeMappingOption[0]);
                this.mapping(Field.class, FieldInfo.class, new TypeMappingOption[0]);
            }
        };
        dozerBeanMapper.addMapping(builder);
        this.mapper = dozerBeanMapper;
    }

    public SchemaInfo convertFromSchemaDto(SchemaDto schemaDto) {
        return (SchemaInfo)this.mapper.map((Object)schemaDto, SchemaInfo.class);
    }

    public SchemaDto convertToSchemaDto(SchemaInfo schemaInfo) {
        return (SchemaDto)this.mapper.map((Object)schemaInfo, SchemaDto.class);
    }

    public SchemaRecordDto convertToSchemaRecordDto(SchemaRecordInfo recordInfo) {
        SchemaRecordDto recordDto = (SchemaRecordDto)this.mapper.map((Object)recordInfo, SchemaRecordDto.class);
        recordDto.setRecordId(CommonUtil.getSchemaRecordId(recordDto.getSchemaId(), recordDto.getVersion()));
        return recordDto;
    }

    public StorageServiceContext convertToStorageServiceContext(RequestContext requestContext) {
        return (StorageServiceContext)this.mapper.map((Object)requestContext, StorageServiceContext.class);
    }
}

