/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.storage;

import java.util.List;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.context.RequestContext;
import org.apache.rocketmq.schema.registry.common.context.RequestContextManager;
import org.apache.rocketmq.schema.registry.common.context.StorageServiceContext;
import org.apache.rocketmq.schema.registry.common.model.SchemaInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaRecordInfo;
import org.apache.rocketmq.schema.registry.common.storage.StorageManager;
import org.apache.rocketmq.schema.registry.common.storage.StorageService;
import org.apache.rocketmq.schema.registry.common.utils.StorageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(StorageServiceProxy.class);
    private final StorageManager storageManager;
    private final StorageUtil storageUtil;

    public StorageServiceProxy(StorageManager storageManager, StorageUtil storageUtil) {
        this.storageManager = storageManager;
        this.storageUtil = storageUtil;
    }

    public SchemaInfo register(SchemaInfo schemaInfo) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.register(storageContext, schemaInfo);
    }

    public void delete(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        storageService.delete(storageServiceContext, name);
    }

    public SchemaInfo update(SchemaInfo schemaInfo) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> service = this.storageManager.getStorageService();
        return service.update(storageServiceContext, schemaInfo);
    }

    public SchemaInfo get(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.get(storageServiceContext, name);
    }

    public SchemaRecordInfo getBySubject(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.getBySubject(storageServiceContext, name);
    }

    public SchemaRecordInfo getTargetSchema(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.getTargetSchema(storageServiceContext, name);
    }

    public List<SchemaRecordInfo> listBySubject(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.listBySubject(storageServiceContext, name);
    }

    public List<String> listSubjectsByTenant(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.listSubjectsByTenant(storageServiceContext, name);
    }

    public List<String> listTenants(QualifiedName name) {
        RequestContext requestContext = RequestContextManager.getContext();
        StorageServiceContext storageServiceContext = this.storageUtil.convertToStorageServiceContext(requestContext);
        StorageService<SchemaInfo> storageService = this.storageManager.getStorageService();
        return storageService.listTenants(storageServiceContext, name);
    }
}

