/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.storage;

import org.apache.rocketmq.schema.registry.common.context.StoragePluginContext;
import org.apache.rocketmq.schema.registry.common.model.StorageType;
import org.apache.rocketmq.schema.registry.common.storage.StorageFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;

public class SpringStorageFactory
implements StorageFactory {
    protected final AnnotationConfigApplicationContext ctx;
    private final StoragePluginContext storagePluginContext;
    private final StorageType storageType;

    public SpringStorageFactory(StoragePluginContext storagePluginContext) {
        this.storagePluginContext = storagePluginContext;
        this.storageType = storagePluginContext.getConfig().getStorageType();
        this.ctx = new AnnotationConfigApplicationContext();
        this.ctx.setEnvironment((ConfigurableEnvironment)new StandardEnvironment());
        this.ctx.getBeanFactory().registerSingleton("StoragePluginContext", (Object)storagePluginContext);
    }

    protected void registerClazz(Class<?> ... clazz) {
        this.ctx.register((Class[])clazz);
    }

    public void refresh() {
        this.ctx.refresh();
    }

    @Override
    public StorageType getStorageType() {
        return this.storageType;
    }

    @Override
    public void stop() {
        this.ctx.close();
    }
}

