/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.context;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.Nullable;

public class RequestContext
implements Serializable {
    private static final long serialVersionUID = 1772214628830653791L;
    public static final String UNKNOWN = "UNKNOWN";
    private final long timestamp = System.currentTimeMillis();
    private final String id = UUID.randomUUID().toString();
    private String userName;
    private final String clientAppName;
    private final String clientId;
    private final String apiUri;
    private final String scheme;
    private final String token;

    public RequestContext() {
        this.userName = null;
        this.clientAppName = null;
        this.clientId = null;
        this.apiUri = UNKNOWN;
        this.scheme = UNKNOWN;
        this.token = null;
    }

    protected RequestContext(@Nullable String userName, @Nullable String clientAppName, @Nullable String clientId, String apiUri, String scheme, String token) {
        this.userName = userName;
        this.clientAppName = clientAppName;
        this.clientId = clientId;
        this.apiUri = apiUri;
        this.scheme = scheme;
        this.token = token;
    }

    public String toString() {
        return "RequestContext{timestamp=" + this.timestamp + ", id='" + this.id + '\'' + ", userName='" + this.userName + '\'' + ", clientAppName='" + this.clientAppName + '\'' + ", clientId='" + this.clientId + '\'' + ", apiUri='" + this.apiUri + '\'' + ", scheme='" + this.scheme + '\'' + ", metaAccount='" + this.token + '\'' + '}';
    }

    public static RequestContextBuilder builder() {
        return new RequestContextBuilder();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getClientAppName() {
        return this.clientAppName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getToken() {
        return this.token;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestContext)) {
            return false;
        }
        RequestContext other = (RequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$clientAppName = this.getClientAppName();
        String other$clientAppName = other.getClientAppName();
        if (this$clientAppName == null ? other$clientAppName != null : !this$clientAppName.equals(other$clientAppName)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$apiUri = this.getApiUri();
        String other$apiUri = other.getApiUri();
        if (this$apiUri == null ? other$apiUri != null : !this$apiUri.equals(other$apiUri)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $clientAppName = this.getClientAppName();
        result = result * 59 + ($clientAppName == null ? 43 : $clientAppName.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $apiUri = this.getApiUri();
        result = result * 59 + ($apiUri == null ? 43 : $apiUri.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public static class RequestContextBuilder {
        private String userName;
        private String clientAppName;
        private String clientId;
        private String apiUri;
        private String scheme;
        private String token;

        RequestContextBuilder() {
        }

        public RequestContextBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public RequestContextBuilder clientAppName(String clientAppName) {
            this.clientAppName = clientAppName;
            return this;
        }

        public RequestContextBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public RequestContextBuilder apiUri(String apiUri) {
            this.apiUri = apiUri;
            return this;
        }

        public RequestContextBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public RequestContextBuilder token(String token) {
            this.token = token;
            return this;
        }

        public RequestContext build() {
            return new RequestContext(this.userName, this.clientAppName, this.clientId, this.apiUri, this.scheme, this.token);
        }

        public String toString() {
            return "RequestContext.RequestContextBuilder(userName=" + this.userName + ", clientAppName=" + this.clientAppName + ", clientId=" + this.clientId + ", apiUri=" + this.apiUri + ", scheme=" + this.scheme + ", token=" + this.token + ")";
        }
    }
}

