/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.auth;

import java.util.Map;
import java.util.Set;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.auth.AccessControlService;
import org.apache.rocketmq.schema.registry.common.exception.SchemaAuthorizedException;
import org.apache.rocketmq.schema.registry.common.model.SchemaOperation;
import org.apache.rocketmq.schema.registry.common.properties.GlobalConfig;

public class DefaultAccessControlServiceImpl
implements AccessControlService {
    private final GlobalConfig config;

    public DefaultAccessControlServiceImpl(GlobalConfig config) {
        this.config = config;
    }

    @Override
    public void checkPermission(String role, String resource, SchemaOperation operation) throws SchemaAuthorizedException {
        if (this.config.isAclEnabled()) {
            this.checkPermission(this.config.getAcl(), role, resource, operation);
        }
    }

    private void checkPermission(Map<QualifiedName, Set<String>> accessACL, String userName, String name, SchemaOperation operation) {
        Set users = null;
        if (users != null && !users.isEmpty() && !users.contains(userName)) {
            throw new SchemaAuthorizedException(String.format("%s is not permitted for %s %s", userName, operation.name(), name));
        }
    }
}

