/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.rocketmq.schema.registry.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.rocketmq.schema.registry.common.exception.SchemaException;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class SchemaDetailInfo implements Serializable {
    private static final long serialVersionUID = 3113021009662503334L;

    private List<SchemaRecordInfo> schemaRecords = new ArrayList<>();

    public SchemaDetailInfo(SchemaRecordInfo firstSchemaRecord) {
        this.schemaRecords.add(firstSchemaRecord);
    }

    public SchemaRecordInfo lastRecord() {
        if (schemaRecords == null || schemaRecords.isEmpty()) {
            throw new SchemaException("Schema record could not been empty");
        }
        return schemaRecords.get(schemaRecords.size() - 1);
    }
}
