/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.rocketmq.schema.registry.client.exceptions.RestClientException;
import org.apache.rocketmq.schema.registry.client.rest.JacksonMapper;
import org.apache.rocketmq.schema.registry.common.utils.ErrorMessage;

public class HttpUtil {
    public static ObjectMapper jsonParser = JacksonMapper.INSTANCE;
    private static final int HTTP_CONNECT_TIMEOUT_MS = 30000;
    private static final int HTTP_READ_TIMEOUT_MS = 30000;
    private static final int PARSE_ERROR_CODE = 5001;

    public static <T> T sendHttpRequest(String requestUrl, String method, String requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        HttpURLConnection connection = null;
        try {
            ErrorMessage errorMessage;
            int responseCode;
            URL url = new URL(requestUrl);
            connection = HttpUtil.buildConnection(url, method, requestProperties);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(requestBodyData.getBytes(StandardCharsets.UTF_8));
                    os.flush();
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                InputStream is = connection.getInputStream();
                Object result = jsonParser.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            try (InputStream es = connection.getErrorStream();){
                errorMessage = es != null ? (ErrorMessage)jsonParser.readValue(es, ErrorMessage.class) : new ErrorMessage(5001, "request error");
            }
            catch (JsonProcessingException e) {
                errorMessage = new ErrorMessage(5001, e.getMessage());
            }
            throw new RestClientException(errorMessage.getStatus(), errorMessage.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static HttpURLConnection buildConnection(URL url, String method, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection connection = null;
        connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        connection.setRequestMethod(method);
        connection.setDoInput(true);
        for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setUseCaches(false);
        return connection;
    }

    public static String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }
}

