/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.avro;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.specific.SpecificRecord;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.serde.Deserializer;
import org.apache.rocketmq.schema.registry.client.serde.Serializer;
import org.apache.rocketmq.schema.registry.client.serde.avro.AvroDeserializer;
import org.apache.rocketmq.schema.registry.client.serde.avro.AvroSerializer;

public class SpecificAvroSerde<T extends SpecificRecord>
implements Closeable {
    private final AvroSerializer<T> serializer;
    private final AvroDeserializer<T> deserializer;

    public SpecificAvroSerde() {
        this.serializer = new AvroSerializer();
        this.deserializer = new AvroDeserializer();
    }

    public SpecificAvroSerde(SchemaRegistryClient client) {
        if (null == client) {
            throw new IllegalArgumentException("please initialize schema registry client first");
        }
        this.serializer = new AvroSerializer(client);
        this.deserializer = new AvroDeserializer(client);
    }

    public Serializer<T> serializer() {
        return this.serializer;
    }

    public Deserializer<T> deserializer() {
        return this.deserializer;
    }

    public void configure(Map<String, Object> configs) {
        this.serializer.configure(configs);
        this.deserializer.configure(configs);
    }

    @Override
    public void close() throws IOException {
        this.serializer.close();
        this.deserializer.close();
    }
}

