/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.rocketmq.schema.registry.client.exceptions.SerializationException;
import org.apache.rocketmq.schema.registry.client.serde.Serializer;

public class ReflectionAvroSerializer<T>
implements Serializer<T> {
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    @Override
    public void configure(Map<String, Object> configs) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(String subject, T record) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] bytes;
            BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
            Schema schema = ReflectData.get().getSchema(record.getClass());
            ReflectDatumWriter datumWriter = new ReflectDatumWriter(schema);
            datumWriter.write(record, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = bytes = out.toByteArray();
            return byArray;
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException("serialize Avro message failed", e);
        }
    }

    @Override
    public void close() {
    }
}

