/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.client.serde.avro;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.rocketmq.schema.registry.client.SchemaRegistryClient;
import org.apache.rocketmq.schema.registry.client.serde.avro.GenericAvroDeserializer;
import org.apache.rocketmq.schema.registry.client.serde.avro.GenericAvroSerializer;

public class GenericAvroSerde
implements Closeable {
    private final GenericAvroSerializer serializer;
    private final GenericAvroDeserializer deserializer;

    public GenericAvroSerde() {
        this.serializer = new GenericAvroSerializer();
        this.deserializer = new GenericAvroDeserializer();
    }

    public GenericAvroSerde(SchemaRegistryClient client) {
        if (null == client) {
            throw new IllegalArgumentException("please initialize the schema registry client first");
        }
        this.serializer = new GenericAvroSerializer(client);
        this.deserializer = new GenericAvroDeserializer(client);
    }

    public void configure(Map<String, Object> configs) {
        this.serializer.configure(configs);
        this.deserializer.configure(configs);
    }

    public GenericAvroSerializer serializer() {
        return this.serializer;
    }

    public GenericAvroDeserializer deserializer() {
        return this.deserializer;
    }

    @Override
    public void close() throws IOException {
        this.serializer.close();
        this.deserializer.close();
    }
}

