/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.SelectorType;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface RocketMQMessageListener {
    public static final String NAME_SERVER_PLACEHOLDER = "${rocketmq.name-server:}";
    public static final String ACCESS_KEY_PLACEHOLDER = "${rocketmq.consumer.access-key:}";
    public static final String SECRET_KEY_PLACEHOLDER = "${rocketmq.consumer.secret-key:}";
    public static final String TRACE_TOPIC_PLACEHOLDER = "${rocketmq.consumer.customized-trace-topic:}";
    public static final String ACCESS_CHANNEL_PLACEHOLDER = "${rocketmq.access-channel:}";

    public String consumerGroup();

    public String topic();

    public SelectorType selectorType() default SelectorType.TAG;

    public String selectorExpression() default "*";

    public ConsumeMode consumeMode() default ConsumeMode.CONCURRENTLY;

    public MessageModel messageModel() default MessageModel.CLUSTERING;

    public int consumeThreadMax() default 64;

    public int consumeThreadNumber() default 20;

    public int maxReconsumeTimes() default -1;

    public long consumeTimeout() default 15L;

    public int replyTimeout() default 3000;

    public String accessKey() default "${rocketmq.consumer.access-key:}";

    public String secretKey() default "${rocketmq.consumer.secret-key:}";

    public boolean enableMsgTrace() default false;

    public String customizedTraceTopic() default "${rocketmq.consumer.customized-trace-topic:}";

    public String nameServer() default "${rocketmq.name-server:}";

    public String accessChannel() default "${rocketmq.access-channel:}";

    public String tlsEnable() default "false";

    public String namespace() default "";

    public String namespaceV2() default "";

    public int delayLevelWhenNextConsume() default 0;

    public int suspendCurrentQueueTimeMillis() default 1000;

    public int awaitTerminationMillisWhenShutdown() default 1000;

    public String instanceName() default "DEFAULT";
}

