/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogWorker;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public interface SegmentedRaftLogTestUtils {
    public static final SizeInBytes MAX_OP_SIZE = SizeInBytes.valueOf((String)"32MB");

    public static SegmentedRaftLogInputStream newSegmentedRaftLogInputStream(File log, long startIndex, long endIndex, boolean isOpen) {
        LogSegmentStartEnd startEnd = LogSegmentStartEnd.valueOf((long)startIndex, (long)endIndex, (boolean)isOpen);
        return new SegmentedRaftLogInputStream(log, startEnd, MAX_OP_SIZE, null);
    }

    public static void setRaftLogWorkerLogLevel(Level level) {
        Slf4jUtils.setLogLevel((Logger)SegmentedRaftLogWorker.LOG, (Level)level);
    }

    public static List<Path> getOpenLogFiles(RaftServer.Division server) throws Exception {
        return LogSegmentPath.getLogSegmentPaths((RaftStorage)server.getRaftStorage()).stream().filter(p -> p.getStartEnd().isOpen()).map(LogSegmentPath::getPath).collect(Collectors.toList());
    }
}

