/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.raftlog.RaftLog;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class ServerPauseResumeTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testPauseResume() throws Exception {
        RaftServerConfigKeys.Log.Appender.setRetryPolicy((RaftProperties)this.getProperties(), (String)"1ms,1000");
        this.runWithNewCluster(3, this::runTestPauseResume);
    }

    void runTestPauseResume(CLUSTER cluster) throws InterruptedException, IOException {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        List<RaftServer.Division> followers = ((MiniRaftCluster)cluster).getFollowers();
        Assertions.assertTrue((followers.size() >= 1 ? 1 : 0) != 0);
        RaftServerImpl follower = (RaftServerImpl)followers.get(0);
        RaftTestUtil.SimpleMessage[] batch1 = RaftTestUtil.SimpleMessage.create(100, "batch1");
        Thread writeThread = RaftTestUtil.sendMessageInNewThread(cluster, leaderId, batch1);
        writeThread.join();
        Thread.sleep(((MiniRaftCluster)cluster).getTimeoutMax().toLong(TimeUnit.MILLISECONDS) * 5L);
        RaftLog leaderLog = leader.getRaftLog();
        Assertions.assertTrue((boolean)RaftTestUtil.logEntriesContains(leaderLog, batch1));
        RaftLog followerLog = follower.getRaftLog();
        Assertions.assertTrue((boolean)RaftTestUtil.logEntriesContains(followerLog, batch1));
        boolean isSuccess = follower.pause();
        Assertions.assertTrue((boolean)isSuccess);
        Assertions.assertTrue((boolean)follower.getInfo().getLifeCycleState().isPausingOrPaused());
        RaftTestUtil.SimpleMessage[] batch2 = RaftTestUtil.SimpleMessage.create(100, "batch2");
        Thread writeThread2 = RaftTestUtil.sendMessageInNewThread(cluster, leaderId, batch2);
        writeThread2.join();
        Thread.sleep(((MiniRaftCluster)cluster).getTimeoutMax().toLong(TimeUnit.MILLISECONDS) * 5L);
        Assertions.assertTrue((boolean)RaftTestUtil.logEntriesNotContains(followerLog, batch2));
        isSuccess = follower.resume();
        Assertions.assertTrue((boolean)isSuccess);
        Assertions.assertFalse((boolean)follower.getInfo().getLifeCycleState().isPausingOrPaused());
        Thread.sleep(((MiniRaftCluster)cluster).getTimeoutMax().toLong(TimeUnit.MILLISECONDS) * 5L);
        Assertions.assertTrue((boolean)RaftTestUtil.logEntriesContains(followerLog, batch2));
    }
}

