/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class PreAppendLeaderStepDownTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private static volatile boolean leaderShouldStepDown = false;

    public PreAppendLeaderStepDownTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithException.class, StateMachine.class);
    }

    @Test
    public void testLeaderStepDown() throws Exception {
        leaderShouldStepDown = true;
        this.runWithNewCluster(3, this::runTestLeaderStepDown);
    }

    @Test
    public void testNoLeaderStepDown() throws Exception {
        leaderShouldStepDown = false;
        this.runWithNewCluster(3, this::runTestLeaderStepDown);
    }

    private void runTestLeaderStepDown(CLUSTER cluster) throws Exception {
        RaftServer.Division oldLeader = RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(oldLeader.getId());){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage("message");
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), oldLeader.getId(), 999L, message);
            long oldTerm = RaftTestUtil.waitForLeader(cluster).getRaftLog().getLastEntryTermIndex().getTerm();
            rpc.sendRequest(r);
            TimeDuration.ONE_SECOND.sleep();
            long newTerm = RaftTestUtil.waitForLeader(cluster).getRaftLog().getLastEntryTermIndex().getTerm();
            if (leaderShouldStepDown) {
                Assertions.assertTrue((newTerm > oldTerm ? 1 : 0) != 0);
            } else {
                Assertions.assertEquals((long)newTerm, (long)oldTerm);
            }
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    @Test
    public void testLeaderStepDownAsync() throws Exception {
        this.runWithNewCluster(3, this::runTestLeaderStepDownAsync);
    }

    void runTestLeaderStepDownAsync(CLUSTER cluster) throws IOException, InterruptedException {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        RaftServerImpl l = (RaftServerImpl)leader;
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leader.getId());){
            JavaUtils.attempt(() -> Assertions.assertEquals((Object)leaderId, (Object)leader.getId()), (int)20, (TimeDuration)ONE_SECOND, (String)"check leader id", (Logger)this.LOG);
            RaftClientReply reply = client.admin().transferLeadership(null, 3000L);
            Assertions.assertTrue((boolean)reply.isSuccess());
            Assertions.assertEquals((int)2, (int)((RaftServerImpl)leader).getRole().getCurrentRole().getNumber());
        }
    }

    protected static class StateMachineWithException
    extends SimpleStateMachine4Testing {
        protected StateMachineWithException() {
        }

        public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
            throw new StateMachineException("Fake Exception in preAppend", leaderShouldStepDown);
        }
    }
}

