/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.JavaUtils;

public class DelayLocalExecutionInjection
implements CodeInjectionForTesting.Code {
    private final Map<String, AtomicInteger> delays = new ConcurrentHashMap<String, AtomicInteger>();

    public DelayLocalExecutionInjection(String ... methods) {
        for (String method : methods) {
            CodeInjectionForTesting.put((String)method, (CodeInjectionForTesting.Code)this);
        }
    }

    public void clear() {
        this.delays.clear();
    }

    public void setDelayMs(String id, int delayMs) {
        AtomicInteger d = this.delays.get(id);
        if (d == null) {
            d = new AtomicInteger();
            this.delays.put(id, d);
        }
        d.set(delayMs);
    }

    public void removeDelay(String id) {
        this.delays.remove(id);
    }

    public boolean execute(Object localId, Object remoteId, Object ... args) {
        if (localId == null) {
            return false;
        }
        String localIdStr = localId.toString();
        AtomicInteger d = this.delays.get(localIdStr);
        if (d == null) {
            return false;
        }
        LOG.info("{} delay {} ms, args={}", new Object[]{localIdStr, d.get(), Arrays.toString(args)});
        try {
            RaftTestUtil.delay(d::get);
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while delaying " + localIdStr);
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ": delays=" + this.delays;
    }
}

