/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.usergroupsync;

import java.io.File;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.util.RangerMetricsUtil;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;

public class UserSyncMetricsProducer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UserSyncMetricsProducer.class);
    private boolean shutdownFlag = false;

    public static void main(String[] args) {
        UserSyncMetricsProducer userSyncMetrics = new UserSyncMetricsProducer();
        userSyncMetrics.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
                long sleepTimeBetweenCycleInMillis = config.getUserSyncMetricsFrequency();
                String logFileNameWithPath = config.getUserSyncMetricsFileName();
                LOG.info((Object)("user sync metrics frequency :  " + sleepTimeBetweenCycleInMillis + " and metrics file : " + logFileNameWithPath));
                if (null != logFileNameWithPath) {
                    while (!this.shutdownFlag) {
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Sleeping metrics for [" + sleepTimeBetweenCycleInMillis + "] milliSeconds"));
                            }
                            Thread.sleep(sleepTimeBetweenCycleInMillis);
                        }
                        catch (InterruptedException e) {
                            LOG.error((Object)("Failed to wait for [" + sleepTimeBetweenCycleInMillis + "] milliseconds before attempting to fetch userSync metrics information"), (Throwable)e);
                        }
                        try {
                            this.writeJVMMetrics(logFileNameWithPath);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)"Failed to write user sync metrics into file. Error details: ", t);
                        }
                    }
                    break block12;
                }
                LOG.info((Object)"No file directory found for usersync metrics log ");
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to start user sync metrics. Error details: ", t);
            }
            finally {
                LOG.info((Object)"Shutting down the User Sync metrics producer thread");
            }
        }
    }

    private void writeJVMMetrics(String logFileNameWithPath) throws Throwable {
        try {
            File userMetricFile = null;
            userMetricFile = new File(logFileNameWithPath);
            if (!userMetricFile.exists()) {
                userMetricFile.createNewFile();
            }
            RangerMetricsUtil rangerMetricsUtil = new RangerMetricsUtil();
            rangerMetricsUtil.writeMetricsToFile(userMetricFile);
        }
        catch (Throwable t) {
            LOG.error((Object)"UserSyncMetricsProducer.writeJVMMetrics() failed to write metrics into file. Error details: ", t);
            throw t;
        }
    }
}

