/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.ranger.ugsyncutil.model.UgsyncAuditInfo;
import org.apache.ranger.ugsyncutil.model.UnixSyncSourceInfo;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;

public class UnixUserGroupBuilder
implements UserGroupSource {
    private static final Logger LOG = Logger.getLogger(UnixUserGroupBuilder.class);
    private static final String OS = System.getProperty("os.name");
    static final String LINUX_GET_ALL_USERS_CMD = "getent passwd";
    static final String LINUX_GET_ALL_GROUPS_CMD = "getent group";
    static final String LINUX_GET_GROUP_CMD = "getent group %s";
    static final String MAC_GET_ALL_USERS_CMD = "dscl . -readall /Users UniqueID PrimaryGroupID | awk 'BEGIN { OFS = \":\"; ORS=\"\\n\"; i=0;}/RecordName: / {name = $2;i = 0;}/PrimaryGroupID: / {gid = $2;}/^ / {if (i == 0) { i++; name = $1;}}/UniqueID: / {uid = $2;print name, \"*\", gid, uid;}'";
    static final String MAC_GET_ALL_GROUPS_CMD = "dscl . -list /Groups PrimaryGroupID | awk -v OFS=\":\" '{print $1, \"*\", $2, \"\"}'";
    static final String MAC_GET_GROUP_CMD = "dscl . -read /Groups/%1$s | paste -d, -s - | sed -e 's/:/|/g' | awk -v OFS=\":\" -v ORS=\"\\n\" -F, '{print \"%1$s\",\"*\",$6,$4}' | sed -e 's/:[^:]*| /:/g' | sed -e 's/ /,/g'";
    static final String BACKEND_PASSWD = "passwd";
    private boolean isUpdateSinkSucc = true;
    private boolean enumerateGroupMembers = false;
    private boolean useNss = false;
    private long lastUpdateTime = 0L;
    private long timeout = 0L;
    private UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    private Map<String, String> groupId2groupNameMap;
    private Map<String, Map<String, String>> sourceUsers;
    private Map<String, Map<String, String>> sourceGroups;
    private Map<String, Set<String>> sourceGroupUsers;
    private Table<String, String, String> groupUserTable;
    private int minimumUserId = 0;
    private int minimumGroupId = 0;
    private String unixPasswordFile;
    private String unixGroupFile;
    private long passwordFileModifiedAt = 0L;
    private long groupFileModifiedAt = 0L;
    private UgsyncAuditInfo ugsyncAuditInfo;
    private UnixSyncSourceInfo unixSyncSourceInfo;
    private boolean isStartupFlag = true;
    private int deleteCycles;
    private String currentSyncSource;
    private boolean computeDeletes = false;
    Set<String> allGroups = new HashSet<String>();

    public static void main(String[] args) throws Throwable {
        UnixUserGroupBuilder ugbuilder = new UnixUserGroupBuilder();
        ugbuilder.init();
        ugbuilder.print();
    }

    public UnixUserGroupBuilder() {
        this.minimumUserId = Integer.parseInt(this.config.getMinUserId());
        this.minimumGroupId = Integer.parseInt(this.config.getMinGroupId());
        this.unixPasswordFile = this.config.getUnixPasswordFile();
        this.unixGroupFile = this.config.getUnixGroupFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Minimum UserId: " + this.minimumUserId + ", minimum GroupId: " + this.minimumGroupId));
        }
        this.timeout = this.config.getUpdateMillisMin();
        this.enumerateGroupMembers = this.config.isGroupEnumerateEnabled();
    }

    @Override
    public void init() throws Throwable {
        this.deleteCycles = 1;
        this.currentSyncSource = this.config.getCurrentSyncSource();
        this.ugsyncAuditInfo = new UgsyncAuditInfo();
        this.unixSyncSourceInfo = new UnixSyncSourceInfo();
        this.ugsyncAuditInfo.setSyncSource(this.currentSyncSource);
        this.ugsyncAuditInfo.setUnixSyncSourceInfo(this.unixSyncSourceInfo);
        this.unixSyncSourceInfo.setFileName(this.unixPasswordFile);
        this.unixSyncSourceInfo.setMinUserId(this.config.getMinUserId());
        this.unixSyncSourceInfo.setMinGroupId(this.config.getMinGroupId());
        if (!this.config.getUnixBackend().equalsIgnoreCase(BACKEND_PASSWD)) {
            this.useNss = true;
            this.unixSyncSourceInfo.setUnixBackend("nss");
        } else {
            LOG.warn((Object)"DEPRECATED: Unix backend is configured to use /etc/passwd and /etc/group files directly instead of standard system mechanisms.");
            this.unixSyncSourceInfo.setUnixBackend(BACKEND_PASSWD);
        }
        this.buildUserGroupInfo();
    }

    @Override
    public boolean isChanged() {
        this.computeDeletes = false;
        if (!this.isUpdateSinkSucc) {
            LOG.info((Object)"Previous updateSink failed and hence retry!!");
            this.isUpdateSinkSucc = true;
            return true;
        }
        try {
            if (this.config.isUserSyncDeletesEnabled() && (long)this.deleteCycles >= this.config.getUserSyncDeletesFrequency()) {
                this.deleteCycles = 1;
                this.computeDeletes = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Compute deleted users/groups is enabled for this sync cycle");
                }
                return true;
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to get information about usersync delete frequency", t);
        }
        if (this.config.isUserSyncDeletesEnabled()) {
            ++this.deleteCycles;
        }
        if (this.useNss) {
            return System.currentTimeMillis() - this.lastUpdateTime > this.timeout;
        }
        long TempPasswordFileModifiedAt = new File(this.unixPasswordFile).lastModified();
        if (this.passwordFileModifiedAt != TempPasswordFileModifiedAt) {
            return true;
        }
        long TempGroupFileModifiedAt = new File(this.unixGroupFile).lastModified();
        return this.groupFileModifiedAt != TempGroupFileModifiedAt;
    }

    @Override
    public void updateSink(UserGroupSink sink) throws Throwable {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date lastModifiedTime = new Date(this.passwordFileModifiedAt);
        Date syncTime = new Date(System.currentTimeMillis());
        this.unixSyncSourceInfo.setLastModified(formatter.format(lastModifiedTime));
        this.unixSyncSourceInfo.setSyncTime(formatter.format(syncTime));
        if (this.isChanged() || this.isStartupFlag) {
            this.buildUserGroupInfo();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Users = " + this.sourceUsers.keySet()));
                LOG.debug((Object)("Groups = " + this.sourceGroups.keySet()));
                LOG.debug((Object)("GroupUsers = " + this.sourceGroupUsers.keySet()));
            }
            try {
                sink.addOrUpdateUsersGroups(this.sourceGroups, this.sourceUsers, this.sourceGroupUsers, this.computeDeletes);
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to update ranger admin. Will retry in next sync cycle!!", t);
                this.isUpdateSinkSucc = false;
            }
        }
        try {
            sink.postUserGroupAuditInfo(this.ugsyncAuditInfo);
        }
        catch (Throwable t) {
            LOG.error((Object)"sink.postUserGroupAuditInfo failed with exception: ", t);
        }
        this.isStartupFlag = false;
    }

    private void buildUserGroupInfo() throws Throwable {
        this.groupId2groupNameMap = new HashMap<String, String>();
        this.sourceUsers = new HashMap<String, Map<String, String>>();
        this.sourceGroups = new HashMap<String, Map<String, String>>();
        this.sourceGroupUsers = new HashMap<String, Set<String>>();
        this.groupUserTable = HashBasedTable.create();
        this.allGroups = new HashSet<String>();
        if (OS.startsWith("Mac")) {
            this.buildUnixGroupList(MAC_GET_ALL_GROUPS_CMD, MAC_GET_GROUP_CMD, false);
            this.buildUnixUserList(MAC_GET_ALL_USERS_CMD);
        } else {
            if (!OS.startsWith("Linux")) {
                LOG.warn((Object)"Platform not recognized assuming Linux compatible");
            }
            this.buildUnixGroupList(LINUX_GET_ALL_GROUPS_CMD, LINUX_GET_GROUP_CMD, true);
            this.buildUnixUserList(LINUX_GET_ALL_USERS_CMD);
        }
        for (String groupName : this.groupUserTable.rowKeySet()) {
            Map groupUsersMap = this.groupUserTable.row((Object)groupName);
            HashSet<String> userSet = new HashSet<String>();
            for (String userName : groupUsersMap.keySet()) {
                if (!this.sourceUsers.containsKey(userName)) continue;
                userSet.add(userName);
            }
            this.sourceGroupUsers.put(groupName, userSet);
        }
        this.lastUpdateTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            this.print();
        }
    }

    private void print() {
        for (String user : this.sourceUsers.keySet()) {
            Set groups;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("USER:" + user));
            }
            if ((groups = this.groupUserTable.column((Object)user).keySet()) == null) continue;
            for (String group : groups) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("\tGROUP: " + group));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUnixUserList(String command) throws Throwable {
        String line;
        HashMap<String, String> userName2uid = new HashMap<String, String>();
        try (BufferedReader reader = null;){
            if (!this.useNss) {
                File file = new File(this.unixPasswordFile);
                this.passwordFileModifiedAt = file.lastModified();
                FileInputStream fis = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            } else {
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
                reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            }
            line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String[] tokens = line.split(":");
                int len = tokens.length;
                if (len < 4) {
                    LOG.warn((Object)("Unable to parse: " + line));
                    continue;
                }
                String userName = null;
                String userId = null;
                String groupId = null;
                try {
                    userName = tokens[0];
                    userId = tokens[2];
                    groupId = tokens[3];
                }
                catch (ArrayIndexOutOfBoundsException aiobe) {
                    LOG.warn((Object)("Ignoring line - [" + line + "]: Unable to parse line for getting user information"), (Throwable)aiobe);
                    continue;
                }
                int numUserId = -1;
                try {
                    numUserId = Integer.parseInt(userId);
                }
                catch (NumberFormatException nfe) {
                    LOG.warn((Object)("Unix UserId: [" + userId + "]: can not be parsed as valid int. considering as  -1."), (Throwable)nfe);
                    numUserId = -1;
                }
                if (numUserId >= this.minimumUserId) {
                    userName2uid.put(userName, userId);
                    String groupName = this.groupId2groupNameMap.get(groupId);
                    if (groupName != null) {
                        HashMap<String, String> userAttrMap = new HashMap<String, String>();
                        userAttrMap.put("original_name", userName);
                        userAttrMap.put("full_name", userName);
                        userAttrMap.put("sync_source", this.currentSyncSource);
                        this.sourceUsers.put(userName, userAttrMap);
                        this.groupUserTable.put((Object)groupName, (Object)userName, (Object)groupId);
                        continue;
                    }
                    LOG.warn((Object)("Group Name could not be found for group id: [" + groupId + "]. Skipping adding user [" + userName + "] with id [" + userId + "]."));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skipping user [" + userName + "] since its userid [" + userId + "] is less than minuserid limit [" + this.minimumUserId + "]."));
            }
        }
        if (!this.useNss) {
            return;
        }
        if (this.enumerateGroupMembers) {
            line = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Start drill down group members");
            }
            for (String userName : this.groupUserTable.columnKeySet()) {
                String[] gids;
                if (this.sourceUsers.containsKey(userName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Enumerating user " + userName));
                }
                int numUserId = -1;
                try {
                    numUserId = Integer.parseInt((String)userName2uid.get(userName));
                }
                catch (NumberFormatException nfe) {
                    numUserId = -1;
                }
                if (numUserId < this.minimumUserId && numUserId != -1) continue;
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", "id -G " + userName});
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    reader.close();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("id -G returned " + line));
                }
                if (line == null || line.trim().isEmpty()) {
                    LOG.warn((Object)("User " + userName + " could not be resolved"));
                    continue;
                }
                for (String gid : gids = line.split(" ")) {
                    String groupName;
                    int numGroupId = Integer.parseInt(gid);
                    if (numGroupId < this.minimumGroupId || (groupName = this.groupId2groupNameMap.get(gid)) == null) continue;
                    this.groupUserTable.put((Object)groupName, (Object)userName, (Object)gid);
                }
                HashMap<String, String> userAttrMap = new HashMap<String, String>();
                userAttrMap.put("original_name", userName);
                userAttrMap.put("full_name", userName);
                userAttrMap.put("sync_source", this.currentSyncSource);
                this.sourceUsers.put(userName, userAttrMap);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"End drill down group members");
            }
        }
    }

    private void parseMembers(String line) {
        int numGroupId;
        if (line == null || line.isEmpty()) {
            return;
        }
        String[] tokens = line.split(":");
        if (tokens.length < 3) {
            return;
        }
        String groupName = tokens[0];
        String groupId = tokens[2];
        String groupMembers = null;
        if (tokens.length > 3) {
            groupMembers = tokens[3];
        }
        if (this.groupId2groupNameMap.containsKey(groupId)) {
            this.groupId2groupNameMap.remove(groupId);
        }
        if ((numGroupId = Integer.parseInt(groupId)) < this.minimumGroupId) {
            return;
        }
        this.groupId2groupNameMap.put(groupId, groupName);
        HashMap<String, String> groupAttrMap = new HashMap<String, String>();
        groupAttrMap.put("original_name", groupName);
        groupAttrMap.put("full_name", groupName);
        groupAttrMap.put("sync_source", this.currentSyncSource);
        this.sourceGroups.put(groupName, groupAttrMap);
        if (groupMembers != null && !groupMembers.trim().isEmpty()) {
            for (String user : groupMembers.split(",")) {
                this.groupUserTable.put((Object)groupName, (Object)user, (Object)groupId);
            }
        } else {
            this.sourceGroupUsers.put(groupName, new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildUnixGroupList(String allGroupsCmd, String groupCmd, boolean useGid) throws Throwable {
        String line;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Start enumerating groups");
        }
        try (BufferedReader reader = null;){
            if (!this.useNss) {
                File file = new File(this.unixGroupFile);
                this.groupFileModifiedAt = file.lastModified();
                FileInputStream fis = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            } else {
                Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", allGroupsCmd});
                reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            }
            line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                this.parseMembers(line);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"End enumerating group");
        }
        if (!this.useNss) {
            return;
        }
        if (this.enumerateGroupMembers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Start enumerating group members");
            }
            line = null;
            HashMap<String, String> copy = new HashMap<String, String>(this.groupId2groupNameMap);
            for (Map.Entry entry : copy.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Enumerating group: " + (String)entry.getValue() + " GID(" + (String)entry.getKey() + ")"));
                }
                String command = useGid ? String.format(groupCmd, entry.getKey()) : String.format(groupCmd, entry.getValue());
                Object[] cmd = new String[]{"bash", "-c", command + " " + (String)entry.getKey()};
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing: " + Arrays.toString(cmd)));
                }
                try {
                    Process process = Runtime.getRuntime().exec((String[])cmd);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("bash -c " + command + " for group " + entry + " returned " + line));
                }
                this.parseMembers(line);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"End enumerating group members");
            }
        }
        if (this.config.getEnumerateGroups() != null) {
            line = null;
            String[] groups = this.config.getEnumerateGroups().split(",");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Adding extra groups");
            }
            for (String group : groups) {
                String command = String.format(groupCmd, group);
                Object[] cmd = new String[]{"bash", "-c", command + " '" + group + "'"};
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing: " + Arrays.toString(cmd)));
                }
                try {
                    Process process = Runtime.getRuntime().exec((String[])cmd);
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("bash -c " + command + " for group " + group + " returned " + line));
                }
                this.parseMembers(line);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Done adding extra groups");
            }
        }
    }

    @VisibleForTesting
    Map<String, Set<String>> getGroupUserListMap() {
        return this.sourceGroupUsers;
    }

    @VisibleForTesting
    Map<String, String> getGroupId2groupNameMap() {
        return this.groupId2groupNameMap;
    }

    @VisibleForTesting
    Set<String> getUsers() {
        return this.sourceUsers.keySet();
    }
}

