/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class RangerUgSyncRESTClient
extends RangerRESTClient {
    private static final Log LOG = LogFactory.getLog(RangerUgSyncRESTClient.class);
    private String AUTH_KERBEROS = "kerberos";

    public RangerUgSyncRESTClient(String policyMgrBaseUrls, String ugKeyStoreFile, String ugKeyStoreFilepwd, String ugKeyStoreType, String ugTrustStoreFile, String ugTrustStoreFilepwd, String ugTrustStoreType, String authenticationType, String principal, String keytab, String polMgrUsername, String polMgrPassword) {
        super(policyMgrBaseUrls, "", UserGroupSyncConfig.getInstance().getConfig());
        if (authenticationType == null || !this.AUTH_KERBEROS.equalsIgnoreCase(authenticationType) || !SecureClientLogin.isKerberosCredentialExists((String)principal, (String)keytab)) {
            this.setBasicAuthInfo(polMgrUsername, polMgrPassword);
        }
        if (this.isSSL()) {
            this.setKeyStoreType(ugKeyStoreType);
            this.setTrustStoreType(ugTrustStoreType);
            KeyManager[] kmList = this.getKeyManagers(ugKeyStoreFile, ugKeyStoreFilepwd);
            TrustManager[] tmList = this.getTrustManagers(ugTrustStoreFile, ugTrustStoreFilepwd);
            SSLContext sslContext = this.getSSLContext(kmList, tmList);
            DefaultClientConfig config = new DefaultClientConfig();
            config.getClasses().add(JacksonJsonProvider.class);
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return session.getPeerHost().equals(urlHostName);
                }
            };
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, sslContext));
            this.setClient(Client.create((ClientConfig)config));
            if (StringUtils.isNotEmpty((String)this.getUsername()) && StringUtils.isNotEmpty((String)this.getPassword())) {
                this.getClient().addFilter((ClientFilter)new HTTPBasicAuthFilter(this.getUsername(), this.getPassword()));
            }
        }
    }

    public ClientResponse get(String relativeURL, Map<String, String> params, Cookie sessionId) throws Exception {
        ClientResponse response = null;
        int startIndex = this.getLastKnownActiveUrlIndex();
        int currentIndex = 0;
        for (int index = 0; index < this.getConfiguredURLs().size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.getConfiguredURLs().size();
                WebResource webResource = this.createWebResourceForCookieAuth(currentIndex, relativeURL);
                webResource = RangerUgSyncRESTClient.setQueryParams((WebResource)webResource, params);
                WebResource.Builder br = (WebResource.Builder)webResource.getRequestBuilder().cookie(sessionId);
                response = (ClientResponse)((WebResource.Builder)br.accept(new String[]{"application/json"})).get(ClientResponse.class);
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException e) {
                LOG.warn((Object)("Failed to communicate with Ranger Admin, URL : " + (String)this.getConfiguredURLs().get(currentIndex)));
                this.processException(index, e);
            }
        }
        return response;
    }

    public ClientResponse post(String relativeURL, Map<String, String> params, Object obj, Cookie sessionId) throws Exception {
        ClientResponse response = null;
        int startIndex = this.getLastKnownActiveUrlIndex();
        int currentIndex = 0;
        for (int index = 0; index < this.getConfiguredURLs().size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.getConfiguredURLs().size();
                WebResource webResource = this.createWebResourceForCookieAuth(currentIndex, relativeURL);
                webResource = RangerUgSyncRESTClient.setQueryParams((WebResource)webResource, params);
                WebResource.Builder br = (WebResource.Builder)webResource.getRequestBuilder().cookie(sessionId);
                response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)br.accept(new String[]{"application/json"})).type("application/json")).post(ClientResponse.class, (Object)this.toJson(obj));
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException e) {
                LOG.warn((Object)("Failed to communicate with Ranger Admin, URL : " + (String)this.getConfiguredURLs().get(currentIndex)));
                this.processException(index, e);
            }
        }
        return response;
    }

    public ClientResponse delete(String relativeURL, Map<String, String> params, Cookie sessionId) throws Exception {
        ClientResponse response = null;
        int startIndex = this.getLastKnownActiveUrlIndex();
        int currentIndex = 0;
        for (int index = 0; index < this.getConfiguredURLs().size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.getConfiguredURLs().size();
                WebResource webResource = this.createWebResourceForCookieAuth(currentIndex, relativeURL);
                webResource = RangerUgSyncRESTClient.setQueryParams((WebResource)webResource, params);
                WebResource.Builder br = (WebResource.Builder)webResource.getRequestBuilder().cookie(sessionId);
                response = (ClientResponse)br.delete(ClientResponse.class);
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ClientHandlerException e) {
                LOG.warn((Object)("Failed to communicate with Ranger Admin, URL : " + (String)this.getConfiguredURLs().get(currentIndex)));
                this.processException(index, e);
            }
        }
        return response;
    }
}

