/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.process;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.ranger.ugsyncutil.model.GroupUserInfo;
import org.apache.ranger.ugsyncutil.model.UgsyncAuditInfo;
import org.apache.ranger.ugsyncutil.model.UsersGroupRoleAssignments;
import org.apache.ranger.ugsyncutil.model.XGroupInfo;
import org.apache.ranger.ugsyncutil.model.XUserInfo;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.unixusersync.model.GetXGroupListResponse;
import org.apache.ranger.unixusersync.model.GetXUserListResponse;
import org.apache.ranger.unixusersync.process.RangerUgSyncRESTClient;
import org.apache.ranger.usergroupsync.AbstractUserGroupSource;
import org.apache.ranger.usergroupsync.UserGroupSink;

public class PolicyMgrUserGroupBuilder
extends AbstractUserGroupSource
implements UserGroupSink {
    private static final Logger LOG = Logger.getLogger(PolicyMgrUserGroupBuilder.class);
    private static final String AUTHENTICATION_TYPE = "hadoop.security.authentication";
    private String AUTH_KERBEROS = "kerberos";
    private static final String PRINCIPAL = "ranger.usersync.kerberos.principal";
    private static final String KEYTAB = "ranger.usersync.kerberos.keytab";
    private static final String NAME_RULE = "hadoop.security.auth_to_local";
    public static final String PM_USER_LIST_URI = "/service/xusers/users/";
    private static final String PM_ADD_USERS_URI = "/service/xusers/ugsync/users";
    private static final String PM_ADD_GROUP_USER_LIST_URI = "/service/xusers/ugsync/groupusers";
    public static final String PM_GROUP_LIST_URI = "/service/xusers/groups/";
    private static final String PM_ADD_GROUPS_URI = "/service/xusers/ugsync/groups/";
    public static final String PM_GET_ALL_GROUP_USER_MAP_LIST_URI = "/service/xusers/ugsync/groupusers";
    private static final String PM_AUDIT_INFO_URI = "/service/xusers/ugsync/auditinfo/";
    public static final String PM_UPDATE_USERS_ROLES_URI = "/service/xusers/users/roleassignments";
    private static final String PM_UPDATE_DELETED_GROUPS_URI = "/service/xusers/ugsync/groups/visibility";
    private static final String PM_UPDATE_DELETED_USERS_URI = "/service/xusers/ugsync/users/visibility";
    private static final Pattern USER_OR_GROUP_NAME_VALIDATION_REGEX = Pattern.compile("^([A-Za-z0-9_]|[\u00c0-\u017f])([a-zA-Z0-9\\s,._\\-+/@= ]|[\u00c0-\u017f])+$", 2);
    private static final String SOURCE_EXTERNAL = "1";
    private static final String STATUS_ENABLED = "1";
    private static final String ISVISIBLE = "1";
    private static final String ISHIDDEN = "0";
    private static String LOCAL_HOSTNAME = "unknown";
    private String recordsToPullPerCall = "10";
    private boolean isMockRun = false;
    private String policyMgrBaseUrl;
    private Cookie sessionId = null;
    private boolean isValidRangerCookie = false;
    List<NewCookie> cookieList = new ArrayList<NewCookie>();
    private boolean isStartupFlag;
    private UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();
    private volatile RangerUgSyncRESTClient ldapUgSyncClient;
    private Map<String, XUserInfo> userCache;
    private Map<String, XGroupInfo> groupCache;
    private Map<String, Set<String>> groupUsersCache;
    private Map<String, String> groupNameMap;
    private Map<String, String> userNameMap;
    private Map<String, XGroupInfo> deltaGroups;
    private Map<String, XUserInfo> deltaUsers;
    private Map<String, Set<String>> deltaGroupUsers;
    private Set<String> computeRolesForUsers;
    private Map<String, XGroupInfo> deletedGroups;
    private Map<String, XUserInfo> deletedUsers;
    private int noOfNewUsers;
    private int noOfNewGroups;
    private int noOfModifiedUsers;
    private int noOfModifiedGroups;
    private int noOfDeletedUsers = 0;
    private int noOfDeletedGroups = 0;
    private boolean userNameCaseConversionFlag;
    private boolean groupNameCaseConversionFlag;
    private boolean userNameLowerCaseFlag = false;
    private boolean groupNameLowerCaseFlag = false;
    private String currentSyncSource;
    private String ldapUrl;
    private boolean isUserSyncNameValidationEnabled = false;
    private String authenticationType = null;
    String principal;
    String keytab;
    String nameRules;
    Map<String, String> userMap = new LinkedHashMap<String, String>();
    Map<String, String> groupMap = new LinkedHashMap<String, String>();
    private boolean isRangerCookieEnabled;
    private String rangerCookieName;

    public static void main(String[] args) throws Throwable {
        PolicyMgrUserGroupBuilder ugbuilder = new PolicyMgrUserGroupBuilder();
        ugbuilder.init();
    }

    public PolicyMgrUserGroupBuilder() {
        String userNameCaseConversion = this.config.getUserNameCaseConversion();
        if ("none".equalsIgnoreCase(userNameCaseConversion)) {
            this.userNameCaseConversionFlag = false;
        } else {
            this.userNameCaseConversionFlag = true;
            this.userNameLowerCaseFlag = "lower".equalsIgnoreCase(userNameCaseConversion);
        }
        String groupNameCaseConversion = this.config.getGroupNameCaseConversion();
        if ("none".equalsIgnoreCase(groupNameCaseConversion)) {
            this.groupNameCaseConversionFlag = false;
        } else {
            this.groupNameCaseConversionFlag = true;
            this.groupNameLowerCaseFlag = "lower".equalsIgnoreCase(groupNameCaseConversion);
        }
    }

    @Override
    public synchronized void init() throws Throwable {
        this.isUserSyncNameValidationEnabled = this.config.isUserSyncNameValidationEnabled();
        this.recordsToPullPerCall = this.config.getMaxRecordsPerAPICall();
        this.policyMgrBaseUrl = this.config.getPolicyManagerBaseURL();
        this.isMockRun = this.config.isMockRunEnabled();
        this.isRangerCookieEnabled = this.config.isUserSyncRangerCookieEnabled();
        this.rangerCookieName = this.config.getRangerAdminCookieName();
        this.groupNameMap = new HashMap<String, String>();
        this.userNameMap = new HashMap<String, String>();
        this.userCache = new HashMap<String, XUserInfo>();
        this.groupCache = new HashMap<String, XGroupInfo>();
        this.groupUsersCache = new HashMap<String, Set<String>>();
        this.isStartupFlag = true;
        this.ldapUrl = null;
        this.currentSyncSource = this.config.getCurrentSyncSource();
        if (StringUtils.equalsIgnoreCase((String)this.currentSyncSource, (String)"LDAP/AD")) {
            this.ldapUrl = this.config.getLdapUrl();
        }
        if (this.isMockRun) {
            LOG.setLevel(Level.DEBUG);
        }
        this.sessionId = null;
        String keyStoreFile = this.config.getSSLKeyStorePath();
        String trustStoreFile = this.config.getSSLTrustStorePath();
        String keyStoreFilepwd = this.config.getSSLKeyStorePathPassword();
        String trustStoreFilepwd = this.config.getSSLTrustStorePathPassword();
        String keyStoreType = this.config.getSSLKeyStoreType();
        String trustStoreType = this.config.getSSLTrustStoreType();
        this.authenticationType = this.config.getProperty(AUTHENTICATION_TYPE, "simple");
        try {
            this.principal = SecureClientLogin.getPrincipal((String)this.config.getProperty(PRINCIPAL, ""), (String)LOCAL_HOSTNAME);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.keytab = this.config.getProperty(KEYTAB, "");
        this.nameRules = this.config.getProperty(NAME_RULE, "DEFAULT");
        this.ldapUgSyncClient = new RangerUgSyncRESTClient(this.policyMgrBaseUrl, keyStoreFile, keyStoreFilepwd, keyStoreType, trustStoreFile, trustStoreFilepwd, trustStoreType, this.authenticationType, this.principal, this.keytab, this.config.getPolicyMgrUserName(), this.config.getPolicyMgrPassword());
        String userGroupRoles = this.config.getGroupRoleRules();
        if (userGroupRoles != null && !userGroupRoles.isEmpty()) {
            this.getRoleForUserGroups(userGroupRoles);
        }
        this.buildUserGroupInfo();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilderOld.init()==> PolMgrBaseUrl : " + this.policyMgrBaseUrl + " KeyStore File : " + keyStoreFile + " TrustStore File : " + trustStoreFile + "Authentication Type : " + this.authenticationType));
        }
    }

    @Override
    public void postUserGroupAuditInfo(UgsyncAuditInfo ugsyncAuditInfo) throws Throwable {
        ugsyncAuditInfo.setNoOfNewUsers(Long.valueOf(Integer.toUnsignedLong(this.noOfNewUsers)));
        ugsyncAuditInfo.setNoOfNewGroups(Long.valueOf(Integer.toUnsignedLong(this.noOfNewGroups)));
        ugsyncAuditInfo.setNoOfModifiedUsers(Long.valueOf(Integer.toUnsignedLong(this.noOfModifiedUsers)));
        ugsyncAuditInfo.setNoOfModifiedGroups(Long.valueOf(Integer.toUnsignedLong(this.noOfModifiedGroups)));
        int noOfCachedUsers = this.userCache.size();
        int noOfCachedGroups = this.groupCache.size();
        switch (ugsyncAuditInfo.getSyncSource()) {
            case "LDAP/AD": {
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalUsersSynced((long)noOfCachedUsers);
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalGroupsSynced((long)noOfCachedGroups);
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalUsersDeleted((long)this.noOfDeletedUsers);
                ugsyncAuditInfo.getLdapSyncSourceInfo().setTotalGroupsDeleted((long)this.noOfDeletedGroups);
                break;
            }
            case "Unix": {
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalUsersSynced((long)noOfCachedUsers);
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalGroupsSynced((long)noOfCachedGroups);
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalUsersDeleted((long)this.noOfDeletedUsers);
                ugsyncAuditInfo.getUnixSyncSourceInfo().setTotalGroupsDeleted((long)this.noOfDeletedGroups);
                break;
            }
            case "File": {
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalUsersSynced((long)noOfCachedUsers);
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalGroupsSynced((long)noOfCachedGroups);
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalUsersDeleted((long)this.noOfDeletedUsers);
                ugsyncAuditInfo.getFileSyncSourceInfo().setTotalGroupsDeleted((long)this.noOfDeletedGroups);
                break;
            }
        }
        if (!this.isMockRun) {
            this.addUserGroupAuditInfo(ugsyncAuditInfo);
        }
    }

    @Override
    public void addOrUpdateUsersGroups(Map<String, Map<String, String>> sourceGroups, Map<String, Map<String, String>> sourceUsers, Map<String, Set<String>> sourceGroupUsers, boolean computeDeletes) throws Throwable {
        this.noOfNewUsers = 0;
        this.noOfNewGroups = 0;
        this.noOfModifiedUsers = 0;
        this.noOfModifiedGroups = 0;
        this.computeRolesForUsers = new HashSet<String>();
        if (!this.isStartupFlag && computeDeletes) {
            LOG.info((Object)"Computing deleted users/groups");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Computing deleted users/groups");
            }
            if (MapUtils.isNotEmpty(sourceGroups)) {
                this.updateDeletedGroups(sourceGroups);
            }
            if (MapUtils.isNotEmpty(sourceUsers)) {
                this.updateDeletedUsers(sourceUsers);
            }
            if (MapUtils.isNotEmpty(this.deletedGroups)) {
                this.groupCache.putAll(this.deletedGroups);
            }
            if (MapUtils.isNotEmpty(this.deletedUsers)) {
                this.userCache.putAll(this.deletedUsers);
            }
        }
        if (MapUtils.isNotEmpty(sourceGroups)) {
            this.addOrUpdateGroups(sourceGroups);
        }
        if (MapUtils.isNotEmpty(sourceUsers)) {
            this.addOrUpdateUsers(sourceUsers);
        }
        if (MapUtils.isNotEmpty(sourceGroupUsers)) {
            this.addOrUpdateGroupUsers(sourceGroupUsers);
        }
        if (this.isStartupFlag) {
            if (MapUtils.isNotEmpty(this.userMap)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("adding " + this.userMap.keySet() + " for computing roles during startup"));
                }
                this.computeRolesForUsers.addAll(this.userMap.keySet());
            }
            if (MapUtils.isNotEmpty(this.groupMap)) {
                for (String groupName : this.groupMap.keySet()) {
                    HashSet groupUsers = null;
                    if (CollectionUtils.isNotEmpty((Collection)this.groupUsersCache.get(groupName))) {
                        groupUsers = new HashSet(this.groupUsersCache.get(groupName));
                    } else if (CollectionUtils.isNotEmpty((Collection)this.deltaGroupUsers.get(groupName))) {
                        groupUsers = new HashSet(this.deltaGroupUsers.get(groupName));
                    }
                    if (groupUsers == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("adding " + groupUsers + " from " + groupName + " for computing roles during startup"));
                    }
                    this.computeRolesForUsers.addAll(groupUsers);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(this.computeRolesForUsers)) {
            this.updateUserRoles();
        }
        this.isStartupFlag = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Update cache");
        }
        if (MapUtils.isNotEmpty(this.deltaGroups)) {
            this.groupCache.putAll(this.deltaGroups);
        }
        if (MapUtils.isNotEmpty(this.deltaUsers)) {
            this.userCache.putAll(this.deltaUsers);
        }
        if (MapUtils.isNotEmpty(this.deltaGroupUsers)) {
            this.groupUsersCache.putAll(this.deltaGroupUsers);
        }
    }

    private void buildUserGroupInfo() throws Throwable {
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> Kerberos Environment : Principal is " + this.principal + " and Keytab is " + this.keytab));
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            LOG.info((Object)("Using principal = " + this.principal + " and keytab = " + this.keytab));
            Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
            Boolean isInitDone = Subject.doAs(sub, new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        PolicyMgrUserGroupBuilder.this.buildGroupList();
                        PolicyMgrUserGroupBuilder.this.buildUserList();
                        PolicyMgrUserGroupBuilder.this.buildGroupUserLinkList();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)"Failed to build Users and Groups from Ranger admin : ", e);
                        return false;
                    }
                    return true;
                }
            });
            if (!isInitDone.booleanValue()) {
                String msg = "Failed to build Users and Groups from Ranger admin";
                LOG.error((Object)msg);
                throw new Exception(msg);
            }
        } else {
            this.buildGroupList();
            this.buildUserList();
            this.buildGroupUserLinkList();
        }
    }

    private void buildGroupList() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.buildGroupList()");
        }
        int totalCount = 100;
        int retrievedCount = 0;
        String relativeUrl = PM_GROUP_LIST_URI;
        while (retrievedCount < totalCount) {
            String response = null;
            ClientResponse clientResp = null;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("pageSize", this.recordsToPullPerCall);
            queryParams.put("startIndex", String.valueOf(retrievedCount));
            Gson gson = new GsonBuilder().create();
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedGetEntity(relativeUrl, retrievedCount);
            } else {
                try {
                    clientResp = this.ldapUgSyncClient.get(relativeUrl, queryParams);
                    if (clientResp != null) {
                        response = (String)clientResp.getEntity(String.class);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to get groups from Ranger, Error is : " + e.getMessage()));
                    throw e;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RESPONSE: [" + response + "]"));
            }
            GetXGroupListResponse groupList = (GetXGroupListResponse)gson.fromJson(response, GetXGroupListResponse.class);
            totalCount = groupList.getTotalCount();
            if (groupList.getXgroupInfoList() != null) {
                for (XGroupInfo g : groupList.getXgroupInfoList()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("GROUP:  Id:" + g.getId() + ", Name: " + g.getName() + ", Description: " + g.getDescription()));
                    }
                    g.setOtherAttrsMap((Map)gson.fromJson(g.getOtherAttributes(), Map.class));
                    this.groupCache.put(g.getName(), g);
                }
                retrievedCount = this.groupCache.size();
            }
            LOG.info((Object)("PolicyMgrUserGroupBuilder.buildGroupList(): No. of groups retrieved from ranger admin " + retrievedCount));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.buildGroupList()");
        }
    }

    private void buildUserList() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.buildUserList()");
        }
        int totalCount = 100;
        int retrievedCount = 0;
        String relativeUrl = PM_USER_LIST_URI;
        while (retrievedCount < totalCount) {
            String response = null;
            ClientResponse clientResp = null;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("pageSize", this.recordsToPullPerCall);
            queryParams.put("startIndex", String.valueOf(retrievedCount));
            Gson gson = new GsonBuilder().create();
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedGetEntity(relativeUrl, retrievedCount);
            } else {
                try {
                    clientResp = this.ldapUgSyncClient.get(relativeUrl, queryParams);
                    if (clientResp != null) {
                        response = (String)clientResp.getEntity(String.class);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to get users from Ranger admin, Error is : " + e.getMessage()));
                    throw e;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RESPONSE: [" + response + "]"));
            }
            GetXUserListResponse userList = (GetXUserListResponse)gson.fromJson(response, GetXUserListResponse.class);
            totalCount = userList.getTotalCount();
            if (userList.getXuserInfoList() != null) {
                for (XUserInfo u : userList.getXuserInfoList()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("USER: Id:" + u.getId() + ", Name: " + u.getName() + ", Description: " + u.getDescription()));
                    }
                    u.setOtherAttrsMap((Map)gson.fromJson(u.getOtherAttributes(), Map.class));
                    this.userCache.put(u.getName(), u);
                }
                retrievedCount = this.userCache.size();
            }
            LOG.info((Object)("PolicyMgrUserGroupBuilder.buildUserList(): No. of users retrieved from ranger admin = " + retrievedCount));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.buildUserList()");
        }
    }

    private void buildGroupUserLinkList() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.buildGroupUserLinkList()");
        }
        String relativeUrl = "/service/xusers/ugsync/groupusers";
        String response = null;
        ClientResponse clientResp = null;
        Gson gson = new GsonBuilder().create();
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedGetEntity(relativeUrl, 0);
        } else {
            try {
                clientResp = this.ldapUgSyncClient.get(relativeUrl, null);
                if (clientResp != null) {
                    response = (String)clientResp.getEntity(String.class);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to get response, group user mappings from Ranger admin. Error is : " + e.getMessage()));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RESPONSE: [" + response + "]"));
        }
        this.groupUsersCache = (Map)gson.fromJson(response, Map.class);
        if (MapUtils.isEmpty(this.groupUsersCache)) {
            this.groupUsersCache = new HashMap<String, Set<String>>();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Group User List : " + this.groupUsersCache.values()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.buildGroupUserLinkList()");
        }
    }

    private void addOrUpdateUsers(Map<String, Map<String, String>> sourceUsers) throws Throwable {
        this.computeUserDelta(sourceUsers);
        if (MapUtils.isNotEmpty(this.deltaUsers) && this.addOrUpdateDeltaUsers() == 0) {
            String msg = "Failed to addorUpdate users to ranger admin";
            LOG.error((Object)msg);
            throw new Exception(msg);
        }
    }

    private void addOrUpdateGroups(Map<String, Map<String, String>> sourceGroups) throws Throwable {
        this.computeGroupDelta(sourceGroups);
        if (MapUtils.isNotEmpty(this.deltaGroups) && this.addOrUpdateDeltaGroups() == 0) {
            String msg = "Failed to addorUpdate groups to ranger admin";
            LOG.error((Object)msg);
            throw new Exception(msg);
        }
    }

    private void addOrUpdateGroupUsers(Map<String, Set<String>> sourceGroupUsers) throws Throwable {
        List<GroupUserInfo> groupUserInfoList = this.computeGroupUsersDelta(sourceGroupUsers);
        if (CollectionUtils.isNotEmpty(groupUserInfoList)) {
            this.noOfModifiedGroups += groupUserInfoList.size();
            if (this.addOrUpdateDeltaGroupUsers(groupUserInfoList) == 0) {
                String msg = "Failed to addorUpdate group memberships to ranger admin";
                LOG.error((Object)msg);
                throw new Exception(msg);
            }
        }
    }

    private void updateUserRoles() throws Throwable {
        if (MapUtils.isNotEmpty(this.groupMap) || MapUtils.isNotEmpty(this.userMap)) {
            UsersGroupRoleAssignments ugRoleAssignments = new UsersGroupRoleAssignments();
            ArrayList<String> allUsers = new ArrayList<String>(this.computeRolesForUsers);
            ugRoleAssignments.setUsers(allUsers);
            ugRoleAssignments.setGroupRoleAssignments(this.groupMap);
            ugRoleAssignments.setUserRoleAssignments(this.userMap);
            if (this.updateRoles(ugRoleAssignments) == null) {
                String msg = "Unable to update roles for " + allUsers;
                LOG.error((Object)msg);
                throw new Exception(msg);
            }
        }
    }

    private void computeGroupDelta(Map<String, Map<String, String>> sourceGroups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.computeGroupDelta(" + sourceGroups.keySet() + ")"));
        }
        this.deltaGroups = new HashMap<String, XGroupInfo>();
        Gson gson = new Gson();
        for (String groupDN : sourceGroups.keySet()) {
            Map<String, String> newGroupAttrs = sourceGroups.get(groupDN);
            String newGroupAttrsStr = gson.toJson(newGroupAttrs);
            String groupName = this.groupNameMap.get(groupDN);
            if (StringUtils.isEmpty((String)groupName)) {
                groupName = this.groupNameTransform(newGroupAttrs.get("original_name").trim());
            }
            if (!this.isValidString(groupName)) {
                LOG.warn((Object)("Ignoring invalid group " + groupName + " Full name = " + groupDN));
                continue;
            }
            if (!this.groupCache.containsKey(groupName)) {
                XGroupInfo newGroup = this.addXGroupInfo(groupName, newGroupAttrs, newGroupAttrsStr);
                this.deltaGroups.put(groupName, newGroup);
                ++this.noOfNewGroups;
                this.groupNameMap.put(groupDN, groupName);
                continue;
            }
            XGroupInfo oldGroup = this.groupCache.get(groupName);
            String oldGroupAttrsStr = oldGroup.getOtherAttributes();
            if (!StringUtils.equalsIgnoreCase((String)oldGroupAttrsStr, (String)newGroupAttrsStr)) {
                String oldGroupDN;
                Map oldGroupAttrs = oldGroup.getOtherAttrsMap();
                String string = oldGroupDN = oldGroupAttrs != null ? (String)oldGroupAttrs.get("full_name") : groupName;
                if (oldGroupAttrs == null || StringUtils.equalsIgnoreCase((String)groupDN, (String)oldGroupDN) && (StringUtils.isEmpty((String)((String)oldGroupAttrs.get("sync_source"))) || StringUtils.equalsIgnoreCase((String)((String)oldGroupAttrs.get("sync_source")), (String)newGroupAttrs.get("sync_source")))) {
                    oldGroup.setOtherAttributes(newGroupAttrsStr);
                    oldGroup.setSyncSource(newGroupAttrs.get("sync_source"));
                    oldGroup.setOtherAttrsMap(newGroupAttrs);
                    this.deltaGroups.put(groupName, oldGroup);
                    ++this.noOfModifiedGroups;
                    this.groupNameMap.put(groupDN, groupName);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skipping to update " + groupName + " as same group name with different DN or sync source already exists"));
                LOG.debug((Object)("old group DN = " + oldGroupDN + " and new group DN = " + groupDN));
                continue;
            }
            this.groupNameMap.put(groupDN, groupName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.computeGroupDelta(" + this.deltaGroups.keySet() + ")"));
        }
    }

    private void computeUserDelta(Map<String, Map<String, String>> sourceUsers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.computeUserDelta(" + sourceUsers.keySet() + ")"));
        }
        this.deltaUsers = new HashMap<String, XUserInfo>();
        Gson gson = new Gson();
        for (String userDN : sourceUsers.keySet()) {
            Map<String, String> newUserAttrs = sourceUsers.get(userDN);
            String newUserAttrsStr = gson.toJson(newUserAttrs);
            String userName = this.userNameMap.get(userDN);
            if (StringUtils.isEmpty((String)userName)) {
                userName = this.userNameTransform(newUserAttrs.get("original_name").trim());
            }
            if (!this.isValidString(userName)) {
                LOG.warn((Object)("Ignoring invalid user " + userName + " Full name = " + userDN));
                continue;
            }
            if (!this.userCache.containsKey(userName)) {
                XUserInfo newUser = this.addXUserInfo(userName, newUserAttrs, newUserAttrsStr);
                this.deltaUsers.put(userName, newUser);
                ++this.noOfNewUsers;
                this.userNameMap.put(userDN, userName);
                continue;
            }
            XUserInfo oldUser = this.userCache.get(userName);
            String oldUserAttrsStr = oldUser.getOtherAttributes();
            if (!StringUtils.equalsIgnoreCase((String)oldUserAttrsStr, (String)newUserAttrsStr)) {
                String oldUserDN;
                Map oldUserAttrs = oldUser.getOtherAttrsMap();
                String string = oldUserDN = oldUserAttrs != null ? (String)oldUserAttrs.get("full_name") : userName;
                if (oldUserAttrs == null || StringUtils.equalsIgnoreCase((String)userDN, (String)oldUserDN) && (StringUtils.isEmpty((String)((String)oldUserAttrs.get("sync_source"))) || StringUtils.equalsIgnoreCase((String)((String)oldUserAttrs.get("sync_source")), (String)newUserAttrs.get("sync_source")))) {
                    oldUser.setOtherAttributes(newUserAttrsStr);
                    oldUser.setSyncSource(newUserAttrs.get("sync_source"));
                    oldUser.setOtherAttrsMap(newUserAttrs);
                    oldUser.setUserSource("1");
                    this.deltaUsers.put(userName, oldUser);
                    ++this.noOfModifiedUsers;
                    this.userNameMap.put(userDN, userName);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Skipping to update " + userName + " as same username with different DN or sync source already exists"));
                LOG.debug((Object)("old user DN = " + oldUserDN + " and new user DN = " + userDN));
                continue;
            }
            this.userNameMap.put(userDN, userName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.computeUserDelta(" + this.deltaUsers.keySet() + ")"));
        }
    }

    private List<GroupUserInfo> computeGroupUsersDelta(Map<String, Set<String>> sourceGroupUsers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.computeGroupUsersDelta(" + sourceGroupUsers.keySet() + ")"));
        }
        this.deltaGroupUsers = new HashMap<String, Set<String>>();
        ArrayList<GroupUserInfo> deltaGroupUserInfoList = new ArrayList<GroupUserInfo>();
        for (String groupDN : sourceGroupUsers.keySet()) {
            String groupName = this.groupNameMap.get(groupDN);
            if (StringUtils.isEmpty((String)groupName)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring group membership update for " + groupDN));
                continue;
            }
            HashSet oldUsers = new HashSet();
            HashSet<String> newUsers = new HashSet<String>();
            HashSet<String> addUsers = new HashSet<String>();
            HashSet<String> delUsers = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)this.groupUsersCache.get(groupName))) {
                oldUsers = new HashSet(this.groupUsersCache.get(groupName));
            }
            for (String userDN : sourceGroupUsers.get(groupDN)) {
                String userName = this.userNameMap.get(userDN);
                if (StringUtils.isEmpty((String)userName)) continue;
                newUsers.add(userName);
                if (!CollectionUtils.isEmpty(oldUsers) && oldUsers.contains(userName)) continue;
                addUsers.add(userName);
            }
            if (CollectionUtils.isNotEmpty(oldUsers)) {
                for (String userName : oldUsers) {
                    if (!CollectionUtils.isEmpty(newUsers) && newUsers.contains(userName)) continue;
                    delUsers.add(userName);
                }
            }
            if (!CollectionUtils.isNotEmpty(addUsers) && !CollectionUtils.isNotEmpty(delUsers)) continue;
            GroupUserInfo groupUserInfo = new GroupUserInfo();
            groupUserInfo.setGroupName(groupName);
            if (CollectionUtils.isNotEmpty(addUsers)) {
                groupUserInfo.setAddUsers(addUsers);
                if (this.groupMap.containsKey(groupName)) {
                    this.computeRolesForUsers.addAll(addUsers);
                }
            }
            if (CollectionUtils.isNotEmpty(delUsers)) {
                groupUserInfo.setDelUsers(delUsers);
                if (this.groupMap.containsKey(groupName)) {
                    this.computeRolesForUsers.addAll(delUsers);
                }
            }
            deltaGroupUserInfoList.add(groupUserInfo);
            this.deltaGroupUsers.put(groupName, newUsers);
        }
        if (CollectionUtils.isNotEmpty(deltaGroupUserInfoList)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.computeGroupUsersDelta(" + deltaGroupUserInfoList + ")"));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.computeGroupUsersDelta(0)");
        }
        return deltaGroupUserInfoList;
    }

    private XUserInfo addXUserInfo(String aUserName, Map<String, String> otherAttrsMap, String otherAttributes) {
        XUserInfo xuserInfo = new XUserInfo();
        xuserInfo.setName(aUserName);
        xuserInfo.setDescription(aUserName + " - add from Unix box");
        xuserInfo.setUserSource("1");
        xuserInfo.setStatus("1");
        xuserInfo.setIsVisible("1");
        ArrayList<String> roleList = new ArrayList<String>();
        if (this.userMap.containsKey(aUserName)) {
            roleList.add(this.userMap.get(aUserName));
        } else {
            roleList.add("ROLE_USER");
        }
        xuserInfo.setUserRoleList(roleList);
        xuserInfo.setOtherAttributes(otherAttributes);
        xuserInfo.setSyncSource(otherAttrsMap.get("sync_source"));
        xuserInfo.setOtherAttrsMap(otherAttrsMap);
        return xuserInfo;
    }

    private XGroupInfo addXGroupInfo(String aGroupName, Map<String, String> otherAttrsMap, String otherAttributes) {
        XGroupInfo addGroup = new XGroupInfo();
        addGroup.setName(aGroupName);
        addGroup.setDescription(aGroupName + " - add from Unix box");
        addGroup.setGroupType("1");
        addGroup.setIsVisible("1");
        addGroup.setGroupSource("1");
        addGroup.setOtherAttributes(otherAttributes);
        addGroup.setSyncSource(otherAttrsMap.get("sync_source"));
        addGroup.setOtherAttrsMap(otherAttrsMap);
        return addGroup;
    }

    private int addOrUpdateDeltaUsers() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.addOrUpdateDeltaUsers(" + this.deltaUsers.keySet() + ")"));
        }
        int ret = 0;
        GetXUserListResponse xUserList = new GetXUserListResponse();
        xUserList.setTotalCount(this.deltaUsers.size());
        xUserList.setXuserInfoList(new ArrayList<XUserInfo>(this.deltaUsers.values()));
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final GetXUserListResponse xUserListFinal = xUserList;
                ret = Subject.doAs(sub, new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getUsers(xUserListFinal);
                        }
                        catch (Throwable e) {
                            LOG.error((Object)"Failed to add or update Users : ", e);
                            return 0;
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to add or update Users : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getUsers(xUserList);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.addOrUpdateDeltaUsers(" + this.deltaUsers.keySet() + ")"));
        }
        return ret;
    }

    private int getUsers(GetXUserListResponse xUserList) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.getUsers()");
        }
        int ret = 0;
        int totalCount = xUserList.getTotalCount();
        int uploadedCount = -1;
        int pageSize = Integer.valueOf(this.recordsToPullPerCall);
        while (uploadedCount < totalCount) {
            String response = null;
            ClientResponse clientRes = null;
            String relativeUrl = PM_ADD_USERS_URI;
            GetXUserListResponse pagedXUserList = new GetXUserListResponse();
            int pagedXUserListLen = uploadedCount + pageSize;
            pagedXUserList.setXuserInfoList(xUserList.getXuserInfoList().subList(uploadedCount + 1, pagedXUserListLen > totalCount ? totalCount : pagedXUserListLen));
            pagedXUserList.setTotalCount(pageSize);
            if (pagedXUserList.getXuserInfoList().size() == 0) {
                LOG.info((Object)"PolicyMgrUserGroupBuilder.getUsers() done updating users");
                return 1;
            }
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedUploadEntity(pagedXUserList, relativeUrl);
            } else {
                try {
                    clientRes = this.ldapUgSyncClient.post(relativeUrl, null, pagedXUserList);
                    if (clientRes != null) {
                        response = (String)clientRes.getEntity(String.class);
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to get response, Error is : ", t);
                    throw t;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RESPONSE[" + response + "]"));
            }
            if (StringUtils.isNotEmpty((String)response)) {
                try {
                    ret = Integer.valueOf(response);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Failed to addOrUpdateUsers " + uploadedCount), (Throwable)e);
                    throw e;
                }
            } else {
                LOG.error((Object)("Failed to addOrUpdateUsers " + uploadedCount));
                throw new Exception("Failed to addOrUpdateUsers" + uploadedCount);
            }
            LOG.info((Object)("ret = " + ret + " No. of users uploaded to ranger admin= " + ((uploadedCount += pageSize) > totalCount ? totalCount : uploadedCount)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.getUsers()");
        }
        return ret;
    }

    private int addOrUpdateDeltaGroups() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroups(" + this.deltaGroups.keySet() + ")"));
        }
        int ret = 0;
        GetXGroupListResponse xGroupList = new GetXGroupListResponse();
        xGroupList.setTotalCount(this.deltaGroups.size());
        xGroupList.setXgroupInfoList(new ArrayList<XGroupInfo>(this.deltaGroups.values()));
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final GetXGroupListResponse xGroupListFinal = xGroupList;
                ret = Subject.doAs(sub, new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getGroups(xGroupListFinal);
                        }
                        catch (Throwable e) {
                            LOG.error((Object)"Failed to add or update groups : ", e);
                            return 0;
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to add or update groups : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getGroups(xGroupList);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroups(" + this.deltaGroups.keySet() + ")"));
        }
        return ret;
    }

    private int getGroups(GetXGroupListResponse xGroupList) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.getGroups()");
        }
        int ret = 0;
        int totalCount = xGroupList.getTotalCount();
        int uploadedCount = -1;
        int pageSize = Integer.valueOf(this.recordsToPullPerCall);
        while (uploadedCount < totalCount) {
            String response = null;
            ClientResponse clientRes = null;
            String relativeUrl = PM_ADD_GROUPS_URI;
            GetXGroupListResponse pagedXGroupList = new GetXGroupListResponse();
            int pagedXGroupListLen = uploadedCount + pageSize;
            pagedXGroupList.setXgroupInfoList(xGroupList.getXgroupInfoList().subList(uploadedCount + 1, pagedXGroupListLen > totalCount ? totalCount : pagedXGroupListLen));
            pagedXGroupList.setTotalCount(pageSize);
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedUploadEntity(pagedXGroupList, relativeUrl);
            } else {
                try {
                    clientRes = this.ldapUgSyncClient.post(relativeUrl, null, pagedXGroupList);
                    if (clientRes != null) {
                        response = (String)clientRes.getEntity(String.class);
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to get response, Error is : ", t);
                    throw t;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RESPONSE[" + response + "]"));
            }
            if (StringUtils.isNotEmpty((String)response)) {
                try {
                    ret = Integer.valueOf(response);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Failed to addOrUpdateGroups " + uploadedCount), (Throwable)e);
                    throw e;
                }
            } else {
                LOG.error((Object)("Failed to addOrUpdateGroups " + uploadedCount));
                throw new Exception("Failed to addOrUpdateGroups " + uploadedCount);
            }
            LOG.info((Object)("ret = " + ret + " No. of groups uploaded to ranger admin= " + ((uploadedCount += pageSize) > totalCount ? totalCount : uploadedCount)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.getGroups()");
        }
        return ret;
    }

    private int addOrUpdateDeltaGroupUsers(List<GroupUserInfo> groupUserInfoList) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroupUsers(" + groupUserInfoList + ")"));
        }
        int ret = 0;
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final List<GroupUserInfo> groupUserInfoListFinal = groupUserInfoList;
                ret = Subject.doAs(sub, new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getGroupUsers(groupUserInfoListFinal);
                        }
                        catch (Throwable e) {
                            LOG.error((Object)"Failed to add or update group memberships : ", e);
                            return 0;
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to add or update group memberships : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getGroupUsers(groupUserInfoList);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.addOrUpdateDeltaGroupUsers(" + groupUserInfoList + ")"));
        }
        return ret;
    }

    private int getGroupUsers(List<GroupUserInfo> groupUserInfoList) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.getGroupUsers()");
        }
        int ret = 0;
        int totalCount = groupUserInfoList.size();
        int uploadedCount = -1;
        int pageSize = Integer.valueOf(this.recordsToPullPerCall);
        while (uploadedCount < totalCount) {
            String response = null;
            ClientResponse clientRes = null;
            String relativeUrl = "/service/xusers/ugsync/groupusers";
            int pagedGroupUserInfoListLen = uploadedCount + pageSize;
            List<GroupUserInfo> pagedGroupUserInfoList = groupUserInfoList.subList(uploadedCount + 1, pagedGroupUserInfoListLen > totalCount ? totalCount : pagedGroupUserInfoListLen);
            if (this.isRangerCookieEnabled) {
                response = this.cookieBasedUploadEntity(pagedGroupUserInfoList, relativeUrl);
            } else {
                try {
                    clientRes = this.ldapUgSyncClient.post(relativeUrl, null, pagedGroupUserInfoList);
                    if (clientRes != null) {
                        response = (String)clientRes.getEntity(String.class);
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to get response, Error is : ", t);
                    throw t;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RESPONSE[" + response + "]"));
            }
            if (StringUtils.isNotEmpty((String)response)) {
                try {
                    ret = Integer.valueOf(response);
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Failed to addOrUpdateGroupUsers " + uploadedCount), (Throwable)e);
                    throw e;
                }
            } else {
                LOG.error((Object)("Failed to addOrUpdateGroupUsers " + uploadedCount));
                throw new Exception("Failed to addOrUpdateGroupUsers " + uploadedCount);
            }
            LOG.info((Object)("ret = " + ret + " No. of group memberships uploaded to ranger admin= " + ((uploadedCount += pageSize) > totalCount ? totalCount : uploadedCount)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.getGroupUsers()");
        }
        return ret;
    }

    private List<String> updateRoles(UsersGroupRoleAssignments ugRoleAssignments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.updateUserRole(" + ugRoleAssignments.getUsers() + ")"));
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final UsersGroupRoleAssignments result = ugRoleAssignments;
                List<String> ret = Subject.doAs(sub, new PrivilegedAction<List<String>>(){

                    @Override
                    public List<String> run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.updateUsersRoles(result);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to add User Group Info : ", (Throwable)e);
                            return null;
                        }
                    }
                });
                return ret;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                return null;
            }
        }
        return this.updateUsersRoles(ugRoleAssignments);
    }

    private List<String> updateUsersRoles(UsersGroupRoleAssignments ugRoleAssignments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.updateUserRoles(" + ugRoleAssignments.getUsers() + ")"));
        }
        List ret = null;
        try {
            int totalCount = ugRoleAssignments.getUsers().size();
            int pageSize = Integer.valueOf(this.recordsToPullPerCall);
            for (int uploadedCount = -1; uploadedCount < totalCount; uploadedCount += pageSize) {
                int pagedUgRoleAssignmentsListLen = uploadedCount + pageSize;
                UsersGroupRoleAssignments pagedUgRoleAssignmentsList = new UsersGroupRoleAssignments();
                pagedUgRoleAssignmentsList.setUsers(ugRoleAssignments.getUsers().subList(uploadedCount + 1, pagedUgRoleAssignmentsListLen > totalCount ? totalCount : pagedUgRoleAssignmentsListLen));
                pagedUgRoleAssignmentsList.setGroupRoleAssignments(ugRoleAssignments.getGroupRoleAssignments());
                pagedUgRoleAssignmentsList.setUserRoleAssignments(ugRoleAssignments.getUserRoleAssignments());
                String response = null;
                ClientResponse clientRes = null;
                Gson gson = new GsonBuilder().create();
                String jsonString = gson.toJson((Object)pagedUgRoleAssignmentsList);
                String url = PM_UPDATE_USERS_ROLES_URI;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("USER role MAPPING" + jsonString));
                }
                if (this.isRangerCookieEnabled) {
                    response = this.cookieBasedUploadEntity(pagedUgRoleAssignmentsList, url);
                } else {
                    try {
                        clientRes = this.ldapUgSyncClient.post(url, null, ugRoleAssignments);
                        if (clientRes != null) {
                            response = (String)clientRes.getEntity(String.class);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error((Object)"Failed to get response, Error is : ", t);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RESPONSE: [" + response + "]"));
                }
                Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                ret = (List)new Gson().fromJson(response, listType);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("ERROR: Unable to update roles for: " + ugRoleAssignments.getUsers()), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.updateUserRoles(" + ret + ")"));
        }
        return ret;
    }

    private void addUserGroupAuditInfo(UgsyncAuditInfo auditInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.addAuditInfo(" + auditInfo.getNoOfNewUsers() + ", " + auditInfo.getNoOfNewGroups() + ", " + auditInfo.getNoOfModifiedUsers() + ", " + auditInfo.getNoOfModifiedGroups() + ", " + auditInfo.getSyncSource() + ")"));
        }
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                final UgsyncAuditInfo auditInfoFinal = auditInfo;
                Subject.doAs(sub, new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        try {
                            PolicyMgrUserGroupBuilder.this.getUserGroupAuditInfo(auditInfoFinal);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Failed to add User : ", (Throwable)e);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to Authenticate Using given Principal and Keytab : ", (Throwable)e);
                return;
            }
        }
        this.getUserGroupAuditInfo(auditInfo);
    }

    private void getUserGroupAuditInfo(UgsyncAuditInfo userInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.getUserGroupAuditInfo()");
        }
        String response = null;
        ClientResponse clientRes = null;
        Gson gson = new GsonBuilder().create();
        String relativeUrl = PM_AUDIT_INFO_URI;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(userInfo, relativeUrl);
        } else {
            try {
                clientRes = this.ldapUgSyncClient.post(relativeUrl, null, userInfo);
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to get response, Error is : ", t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RESPONSE[" + response + "]"));
        }
        gson.fromJson(response, UgsyncAuditInfo.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"AuditInfo Creation successful ");
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.getUserGroupAuditInfo()");
        }
    }

    private String cookieBasedUploadEntity(Object obj, String apiURL) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.cookieBasedUploadEntity()");
        }
        String response = null;
        response = this.sessionId != null && this.isValidRangerCookie ? this.tryUploadEntityWithCookie(obj, apiURL) : this.tryUploadEntityWithCred(obj, apiURL);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.cookieBasedUploadEntity()");
        }
        return response;
    }

    private String cookieBasedGetEntity(String apiURL, int retrievedCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.cookieBasedGetEntity()");
        }
        String response = null;
        response = this.sessionId != null && this.isValidRangerCookie ? this.tryGetEntityWithCookie(apiURL, retrievedCount) : this.tryGetEntityWithCred(apiURL, retrievedCount);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.cookieBasedGetEntity()");
        }
        return response;
    }

    private String tryUploadEntityWithCookie(Object obj, String apiURL) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.tryUploadEntityWithCookie()");
        }
        String response = null;
        ClientResponse clientResp = null;
        try {
            clientResp = this.ldapUgSyncClient.post(apiURL, null, obj, this.sessionId);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 401) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 204 || clientResp.getStatus() == 200) {
                List respCookieList = clientResp.getCookies();
                for (NewCookie cookie : respCookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    if (!this.sessionId.getValue().equalsIgnoreCase(cookie.toCookie().getValue())) {
                        this.sessionId = cookie.toCookie();
                    }
                    this.isValidRangerCookie = true;
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.tryUploadEntityWithCookie()");
        }
        return response;
    }

    private String tryUploadEntityWithCred(Object obj, String apiURL) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.tryUploadEntityInfoWithCred()");
        }
        String response = null;
        ClientResponse clientResp = null;
        Gson gson = new GsonBuilder().create();
        String jsonString = gson.toJson(obj);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("USER GROUP MAPPING" + jsonString));
        }
        try {
            clientResp = this.ldapUgSyncClient.post(apiURL, null, obj);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
            } else if (clientResp.getStatus() == 401) {
                LOG.warn((Object)"Credentials response from ranger is 401.");
            } else if (clientResp.getStatus() == 200 || clientResp.getStatus() == 204) {
                this.cookieList = clientResp.getCookies();
                for (NewCookie cookie : this.cookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    this.sessionId = cookie.toCookie();
                    this.isValidRangerCookie = true;
                    LOG.info((Object)"valid cookie saved ");
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.tryUploadEntityInfoWithCred()");
        }
        return response;
    }

    private String tryGetEntityWithCred(String apiURL, int retrievedCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.tryGetEntityWithCred()");
        }
        String response = null;
        ClientResponse clientResp = null;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pageSize", this.recordsToPullPerCall);
        queryParams.put("startIndex", String.valueOf(retrievedCount));
        try {
            clientResp = this.ldapUgSyncClient.get(apiURL, queryParams);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
            } else if (clientResp.getStatus() == 401) {
                LOG.warn((Object)"Credentials response from ranger is 401.");
            } else if (clientResp.getStatus() == 200 || clientResp.getStatus() == 204) {
                this.cookieList = clientResp.getCookies();
                for (NewCookie cookie : this.cookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    this.sessionId = cookie.toCookie();
                    this.isValidRangerCookie = true;
                    LOG.info((Object)"valid cookie saved ");
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.tryGetEntityWithCred()");
        }
        return response;
    }

    private String tryGetEntityWithCookie(String apiURL, int retrievedCount) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.tryGetEntityWithCookie()");
        }
        String response = null;
        ClientResponse clientResp = null;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pageSize", this.recordsToPullPerCall);
        queryParams.put("startIndex", String.valueOf(retrievedCount));
        try {
            clientResp = this.ldapUgSyncClient.get(apiURL, queryParams, this.sessionId);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to get response, Error is : ", t);
        }
        if (clientResp != null) {
            if (!clientResp.toString().contains(apiURL)) {
                clientResp.setStatus(404);
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 401) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            } else if (clientResp.getStatus() == 204 || clientResp.getStatus() == 200) {
                List respCookieList = clientResp.getCookies();
                for (NewCookie cookie : respCookieList) {
                    if (!cookie.getName().equalsIgnoreCase(this.rangerCookieName)) continue;
                    if (!this.sessionId.getValue().equalsIgnoreCase(cookie.toCookie().getValue())) {
                        this.sessionId = cookie.toCookie();
                    }
                    this.isValidRangerCookie = true;
                    break;
                }
            }
            if (clientResp.getStatus() != 200 && clientResp.getStatus() != 204 && clientResp.getStatus() != 400) {
                this.sessionId = null;
                this.isValidRangerCookie = false;
            }
            clientResp.bufferEntity();
            response = (String)clientResp.getEntity(String.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== PolicyMgrUserGroupBuilder.tryGetEntityWithCookie()");
        }
        return response;
    }

    private void getRoleForUserGroups(String userGroupRolesData) {
        String roleDelimiter = this.config.getRoleDelimiter();
        String userGroupDelimiter = this.config.getUserGroupDelimiter();
        String userNameDelimiter = this.config.getUserGroupNameDelimiter();
        if (roleDelimiter == null || roleDelimiter.isEmpty()) {
            roleDelimiter = "&";
        }
        if (userGroupDelimiter == null || userGroupDelimiter.isEmpty()) {
            userGroupDelimiter = ":";
        }
        if (userNameDelimiter == null || userNameDelimiter.isEmpty()) {
            userNameDelimiter = ",";
        }
        StringTokenizer str = new StringTokenizer(userGroupRolesData, roleDelimiter);
        int flag = 0;
        String userGroupCheck = null;
        String roleName = null;
        while (str.hasMoreTokens()) {
            StringTokenizer userGroupRoles;
            flag = 0;
            String tokens = str.nextToken();
            if (tokens == null || tokens.isEmpty() || (userGroupRoles = new StringTokenizer(tokens, userGroupDelimiter)) == null) continue;
            block6: while (userGroupRoles.hasMoreElements()) {
                String userGroupRolesTokens = userGroupRoles.nextToken();
                if (userGroupRolesTokens == null || userGroupRolesTokens.isEmpty()) continue;
                switch (++flag) {
                    case 1: {
                        roleName = userGroupRolesTokens;
                        continue block6;
                    }
                    case 2: {
                        userGroupCheck = userGroupRolesTokens;
                        continue block6;
                    }
                    case 3: {
                        StringTokenizer userGroupNames = new StringTokenizer(userGroupRolesTokens, userNameDelimiter);
                        if (userGroupNames == null) continue block6;
                        while (userGroupNames.hasMoreElements()) {
                            String userGroup = userGroupNames.nextToken();
                            if (userGroup == null || userGroup.isEmpty()) continue;
                            if (userGroupCheck.trim().equalsIgnoreCase("u")) {
                                this.userMap.put(userGroup.trim(), roleName.trim());
                                continue;
                            }
                            if (!userGroupCheck.trim().equalsIgnoreCase("g")) continue;
                            this.groupMap.put(userGroup.trim(), roleName.trim());
                        }
                        continue block6;
                    }
                }
                this.userMap.clear();
                this.groupMap.clear();
            }
        }
    }

    protected String userNameTransform(String userName) {
        if (this.userNameCaseConversionFlag) {
            userName = this.userNameLowerCaseFlag ? userName.toLowerCase() : userName.toUpperCase();
        }
        if (this.userNameRegExInst != null) {
            userName = this.userNameRegExInst.transform(userName);
        }
        return userName;
    }

    protected String groupNameTransform(String groupName) {
        if (this.groupNameCaseConversionFlag) {
            groupName = this.groupNameLowerCaseFlag ? groupName.toLowerCase() : groupName.toUpperCase();
        }
        if (this.groupNameRegExInst != null) {
            groupName = this.groupNameRegExInst.transform(groupName);
        }
        return groupName;
    }

    protected boolean isValidString(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        if (this.isUserSyncNameValidationEnabled) {
            return USER_OR_GROUP_NAME_VALIDATION_REGEX.matcher(name).matches();
        }
        return true;
    }

    private void updateDeletedGroups(Map<String, Map<String, String>> sourceGroups) throws Throwable {
        this.computeDeletedGroups(sourceGroups);
        if (MapUtils.isNotEmpty(this.deletedGroups) && this.updateDeletedGroups() == 0) {
            String msg = "Failed to update deleted groups to ranger admin";
            LOG.error((Object)msg);
            throw new Exception(msg);
        }
        LOG.info((Object)("No. of groups marked for delete = " + this.deletedGroups.size()));
        this.noOfDeletedGroups += this.deletedGroups.size();
    }

    private void computeDeletedGroups(Map<String, Map<String, String>> sourceGroups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.computeDeletedGroups(" + sourceGroups.keySet() + ")"));
        }
        this.deletedGroups = new HashMap<String, XGroupInfo>();
        for (XGroupInfo groupInfo : this.groupCache.values()) {
            Map groupOtherAttrs = groupInfo.getOtherAttrsMap();
            String groupDN = groupOtherAttrs != null ? (String)groupOtherAttrs.get("full_name") : null;
            if (!StringUtils.isNotEmpty((String)groupDN) || sourceGroups.containsKey(groupDN) || !StringUtils.equalsIgnoreCase((String)((String)groupOtherAttrs.get("sync_source")), (String)this.currentSyncSource) || !StringUtils.equalsIgnoreCase((String)((String)groupOtherAttrs.get("ldap_url")), (String)this.ldapUrl)) continue;
            if (groupInfo.getIsVisible() != ISHIDDEN) {
                groupInfo.setIsVisible(ISHIDDEN);
                this.deletedGroups.put(groupInfo.getName(), groupInfo);
                continue;
            }
            LOG.info((Object)("group " + groupInfo.getName() + " already marked for delete "));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.computeDeletedGroups(" + this.deletedGroups + ")"));
        }
    }

    private int updateDeletedGroups() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.updateDeletedGroups(" + this.deletedGroups + ")"));
        }
        int ret = 0;
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                ret = Subject.doAs(sub, new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getDeletedGroups();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)"Failed to add or update deleted groups : ", e);
                            return 0;
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to add or update deleted groups : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getDeletedGroups();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.updateDeletedGroups(" + this.deletedGroups + ")"));
        }
        return ret;
    }

    private int getDeletedGroups() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.getDeletedGroups()");
        }
        int ret = 0;
        String response = null;
        ClientResponse clientRes = null;
        String relativeUrl = PM_UPDATE_DELETED_GROUPS_URI;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(this.deletedGroups.keySet(), relativeUrl);
        } else {
            try {
                clientRes = this.ldapUgSyncClient.post(relativeUrl, null, this.deletedGroups.keySet());
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to get response, Error is : ", t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RESPONSE[" + response + "]"));
        }
        if (response != null) {
            try {
                ret = Integer.valueOf(response);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Failed to update deleted groups", (Throwable)e);
                throw e;
            }
        } else {
            LOG.error((Object)"Failed to update deleted groups ");
            throw new Exception("Failed to update deleted groups ");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.getDeletedGroups()" + ret));
        }
        return ret;
    }

    private void updateDeletedUsers(Map<String, Map<String, String>> sourceUsers) throws Throwable {
        this.computeDeletedUsers(sourceUsers);
        if (MapUtils.isNotEmpty(this.deletedUsers) && this.updateDeletedUsers() == 0) {
            String msg = "Failed to update deleted users to ranger admin";
            LOG.error((Object)msg);
            throw new Exception(msg);
        }
        LOG.info((Object)("No. of users marked for delete = " + this.deletedUsers.size()));
        this.noOfDeletedUsers += this.deletedUsers.size();
    }

    private void computeDeletedUsers(Map<String, Map<String, String>> sourceUsers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PolicyMgrUserGroupBuilder.computeDeletedUsers(" + sourceUsers.keySet() + ")"));
        }
        this.deletedUsers = new HashMap<String, XUserInfo>();
        for (XUserInfo userInfo : this.userCache.values()) {
            Map userOtherAttrs = userInfo.getOtherAttrsMap();
            String userDN = userOtherAttrs != null ? (String)userOtherAttrs.get("full_name") : null;
            if (!StringUtils.isNotEmpty((String)userDN) || sourceUsers.containsKey(userDN) || !StringUtils.equalsIgnoreCase((String)((String)userOtherAttrs.get("sync_source")), (String)this.currentSyncSource) || !StringUtils.equalsIgnoreCase((String)((String)userOtherAttrs.get("ldap_url")), (String)this.ldapUrl)) continue;
            if (userInfo.getIsVisible() != ISHIDDEN) {
                userInfo.setIsVisible(ISHIDDEN);
                this.deletedUsers.put(userInfo.getName(), userInfo);
                continue;
            }
            LOG.info((Object)("user " + userInfo.getName() + " already marked for delete "));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.computeDeletedUsers(" + this.deletedUsers + ")"));
        }
    }

    private int updateDeletedUsers() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> PolicyMgrUserGroupBuilder.updateDeletedUsers(" + this.deletedUsers + ")"));
        }
        int ret = 0;
        if (this.authenticationType != null && this.AUTH_KERBEROS.equalsIgnoreCase(this.authenticationType) && SecureClientLogin.isKerberosCredentialExists((String)this.principal, (String)this.keytab)) {
            try {
                Subject sub = SecureClientLogin.loginUserFromKeytab((String)this.principal, (String)this.keytab, (String)this.nameRules);
                ret = Subject.doAs(sub, new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        try {
                            return PolicyMgrUserGroupBuilder.this.getDeletedUsers();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)"Failed to add or update deleted users : ", e);
                            return 0;
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to add or update deleted users : ", (Throwable)e);
                throw e;
            }
        } else {
            ret = this.getDeletedUsers();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.updateDeletedUsers(" + this.deletedUsers + ")"));
        }
        return ret;
    }

    private int getDeletedUsers() throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> PolicyMgrUserGroupBuilder.getDeletedUsers()");
        }
        int ret = 0;
        String response = null;
        ClientResponse clientRes = null;
        String relativeUrl = PM_UPDATE_DELETED_USERS_URI;
        if (this.isRangerCookieEnabled) {
            response = this.cookieBasedUploadEntity(this.deletedUsers.keySet(), relativeUrl);
        } else {
            try {
                clientRes = this.ldapUgSyncClient.post(relativeUrl, null, this.deletedUsers.keySet());
                if (clientRes != null) {
                    response = (String)clientRes.getEntity(String.class);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to get response, Error is : ", t);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RESPONSE[" + response + "]"));
        }
        if (response != null) {
            try {
                ret = Integer.valueOf(response);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Failed to update deleted users", (Throwable)e);
                throw e;
            }
        } else {
            LOG.error((Object)"Failed to update deleted users ");
            throw new Exception("Failed to update deleted users ");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== PolicyMgrUserGroupBuilder.getDeletedUsers()" + ret));
        }
        return ret;
    }

    protected void setUserSyncNameValidationEnabled(String isNameValidationEnabled) {
        this.config.setProperty("ranger.usersync.name.validation.enabled", isNameValidationEnabled);
        this.isUserSyncNameValidationEnabled = this.config.isUserSyncNameValidationEnabled();
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOCAL_HOSTNAME = "unknown";
        }
    }
}

