/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ldapusersync.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.apache.ranger.unixusersync.config.UserGroupSyncConfig;
import org.apache.ranger.unixusersync.process.PolicyMgrUserGroupBuilder;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(CustomSSLSocketFactory.class);
    private SSLSocketFactory sockFactory;
    private UserGroupSyncConfig config = UserGroupSyncConfig.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomSSLSocketFactory() {
        SSLContext sslContext = null;
        String keyStoreFile = this.config.getSSLKeyStorePath();
        String keyStoreFilepwd = this.config.getSSLKeyStorePathPassword();
        String trustStoreFile = this.config.getSSLTrustStorePath();
        String trustStoreFilepwd = this.config.getSSLTrustStorePathPassword();
        String keyStoreType = this.config.getSSLKeyStoreType();
        String trustStoreType = this.config.getSSLTrustStoreType();
        try {
            InputStream in;
            KeyManager[] kmList = null;
            TrustManager[] tmList = null;
            if (keyStoreFile != null && keyStoreFilepwd != null) {
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                in = null;
                try {
                    in = this.getFileInputStream(keyStoreFile);
                    if (in == null) {
                        LOG.error((Object)("Unable to obtain keystore from file [" + keyStoreFile + "]"));
                        return;
                    }
                    keyStore.load(in, keyStoreFilepwd.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                    kmList = keyManagerFactory.getKeyManagers();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            if (trustStoreFile != null && trustStoreFilepwd != null) {
                KeyStore trustStore = KeyStore.getInstance(trustStoreType);
                in = null;
                try {
                    in = this.getFileInputStream(trustStoreFile);
                    if (in == null) {
                        LOG.error((Object)("Unable to obtain keystore from file [" + trustStoreFile + "]"));
                        return;
                    }
                    trustStore.load(in, trustStoreFilepwd.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                    tmList = trustManagerFactory.getTrustManagers();
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmList, tmList, new SecureRandom());
            this.sockFactory = sslContext.getSocketFactory();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create SSLConext for communication to policy manager", t);
        }
    }

    public static SSLSocketFactory getDefault() {
        return new CustomSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sockFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sockFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean bln) throws IOException {
        return this.sockFactory.createSocket(socket, host, port, bln);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.sockFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.sockFactory.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress localHost, int localPort) throws IOException {
        return this.sockFactory.createSocket(localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localHost, int localPort) throws IOException {
        return this.sockFactory.createSocket(address, port, localHost, localPort);
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = PolicyMgrUserGroupBuilder.class.getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = this.getClass().getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }
}

