/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import org.apache.log4j.Logger;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;

public class RangerAuditConfig
extends RangerConfiguration {
    private static final Logger LOG = Logger.getLogger(RangerAuditConfig.class);
    private final boolean initSuccess;

    public RangerAuditConfig() {
        this("standalone");
    }

    public RangerAuditConfig(String serviceName) {
        this.initSuccess = this.addAuditResources(serviceName);
    }

    public boolean isInitSuccess() {
        return this.initSuccess;
    }

    private boolean addAuditResources(String serviceName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> addAuditResources()");
        }
        String defaultCfg = "ranger-" + serviceName + "-audit.xml";
        boolean ret = true;
        if (!this.addResourceIfReadable(defaultCfg)) {
            LOG.error((Object)("Could not add " + defaultCfg + " to RangerAuditConfig."));
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addAuditResources(), result=" + ret));
        }
        return ret;
    }
}

