/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider.solr;

import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.SolrAppUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

public class SolrAuditProvider
extends AuditDestination {
    private static final Log LOG = LogFactory.getLog(SolrAuditProvider.class);
    public static final String AUDIT_MAX_QUEUE_SIZE_PROP = "xasecure.audit.solr.async.max.queue.size";
    public static final String AUDIT_MAX_FLUSH_INTERVAL_PROP = "xasecure.audit.solr.async.max.flush.interval.ms";
    public static final String AUDIT_RETRY_WAIT_PROP = "xasecure.audit.solr.retry.ms";
    static final Object lock = new Object();
    volatile SolrClient solrClient = null;
    Date lastConnectTime = null;
    long lastFailTime = 0L;
    int retryWaitTime = 30000;

    @Override
    public void init(Properties props) {
        LOG.info((Object)"init() called");
        super.init(props);
        this.retryWaitTime = MiscUtil.getIntProperty(props, AUDIT_RETRY_WAIT_PROP, this.retryWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() {
        SolrClient me = this.solrClient;
        if (me == null) {
            Object object = lock;
            synchronized (object) {
                me = this.solrClient;
                if (me == null) {
                    long diff;
                    final String solrURL = MiscUtil.getStringProperty(this.props, "xasecure.audit.solr.solr_url");
                    if (this.lastConnectTime != null && (diff = System.currentTimeMillis() - this.lastConnectTime.getTime()) < (long)this.retryWaitTime) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Ignore connecting to solr url=" + solrURL + ", lastConnect=" + diff + "ms"));
                        }
                        return;
                    }
                    this.lastConnectTime = new Date();
                    if (solrURL == null || solrURL.isEmpty()) {
                        LOG.fatal((Object)"Solr URL for Audit is empty");
                        return;
                    }
                    try {
                        me = this.solrClient = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<SolrClient>(){

                            @Override
                            public SolrClient run() throws Exception {
                                HttpSolrClient solrClient = new HttpSolrClient(solrURL);
                                return solrClient;
                            }
                        });
                        if (this.solrClient instanceof HttpSolrClient) {
                            HttpSolrClient httpSolrClient = (HttpSolrClient)this.solrClient;
                            httpSolrClient.setAllowCompression(true);
                            httpSolrClient.setConnectionTimeout(1000);
                        }
                    }
                    catch (Throwable t) {
                        LOG.fatal((Object)("Can't connect to Solr server. URL=" + solrURL), t);
                    }
                }
            }
        }
    }

    @Override
    public boolean log(AuditEventBase event) {
        if (!(event instanceof AuthzAuditEvent)) {
            LOG.error((Object)(event.getClass().getName() + " audit event class type is not supported"));
            return false;
        }
        AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
        if (authzEvent.getAgentHostname() == null) {
            authzEvent.setAgentHostname(MiscUtil.getHostname());
        }
        if (authzEvent.getLogType() == null) {
            authzEvent.setLogType("RangerAudit");
        }
        if (authzEvent.getEventId() == null) {
            authzEvent.setEventId(MiscUtil.generateUniqueId());
        }
        try {
            long diff;
            if (this.solrClient == null) {
                this.connect();
                if (this.solrClient == null) {
                    return false;
                }
            }
            if (this.lastFailTime > 0L && (diff = System.currentTimeMillis() - this.lastFailTime) < (long)this.retryWaitTime) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ignore sending audit. lastConnect=" + diff + " ms"));
                }
                return false;
            }
            SolrInputDocument document = this.toSolrDoc(authzEvent);
            List<SolrInputDocument> docs = Collections.singletonList(document);
            UpdateResponse response = SolrAppUtil.addDocsToSolr(this.solrClient, docs);
            this.lastFailTime = response.getStatus() != 0 ? System.currentTimeMillis() : 0L;
        }
        catch (Throwable t) {
            LOG.error((Object)"Error sending message to Solr", t);
            return false;
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.log(event);
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        for (String event : events) {
            this.logJSON(event);
        }
        return false;
    }

    @Override
    public void start() {
        this.connect();
    }

    @Override
    public void stop() {
    }

    @Override
    public void waitToComplete() {
    }

    @Override
    public void waitToComplete(long timeout) {
    }

    @Override
    public void flush() {
    }

    SolrInputDocument toSolrDoc(AuthzAuditEvent auditEvent) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("id", (Object)auditEvent.getEventId());
        doc.addField("access", (Object)auditEvent.getAccessType());
        doc.addField("enforcer", (Object)auditEvent.getAclEnforcer());
        doc.addField("agent", (Object)auditEvent.getAgentId());
        doc.addField("repo", (Object)auditEvent.getRepositoryName());
        doc.addField("sess", (Object)auditEvent.getSessionId());
        doc.addField("reqUser", (Object)auditEvent.getUser());
        doc.addField("reqData", (Object)auditEvent.getRequestData());
        doc.addField("resource", (Object)auditEvent.getResourcePath());
        doc.addField("cliIP", (Object)auditEvent.getClientIP());
        doc.addField("logType", (Object)auditEvent.getLogType());
        doc.addField("result", (Object)auditEvent.getAccessResult());
        doc.addField("policy", (Object)auditEvent.getPolicyId());
        doc.addField("repoType", (Object)auditEvent.getRepositoryType());
        doc.addField("resType", (Object)auditEvent.getResourceType());
        doc.addField("reason", (Object)auditEvent.getResultReason());
        doc.addField("action", (Object)auditEvent.getAction());
        doc.addField("evtTime", (Object)auditEvent.getEventTime());
        doc.addField("tags", auditEvent.getTags());
        doc.addField("cluster", (Object)auditEvent.getClusterName());
        return doc;
    }

    public boolean isAsync() {
        return true;
    }
}

