/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerPluginClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RangerPluginClassLoader.class);
    ThreadLocal<ClassLoader> preActivateClassLoader = new ThreadLocal();
    private static volatile RangerPluginClassLoader me = null;
    private static MyClassLoader componentClassLoader = null;

    public RangerPluginClassLoader(String pluginType, Class<?> pluginClass) throws Exception {
        super(RangerPluginClassLoaderUtil.getInstance().getPluginFilesForServiceTypeAndPluginclass(pluginType, pluginClass), (ClassLoader)null);
        componentClassLoader = AccessController.doPrivileged(new PrivilegedAction<MyClassLoader>(){

            @Override
            public MyClassLoader run() {
                return new MyClassLoader(Thread.currentThread().getContextClassLoader());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerPluginClassLoader getInstance(final String pluginType, final Class<?> pluginClass) throws Exception {
        RangerPluginClassLoader ret = me;
        if (ret != null) return ret;
        Class<RangerPluginClassLoader> clazz = RangerPluginClassLoader.class;
        synchronized (RangerPluginClassLoader.class) {
            ret = me;
            if (ret != null || pluginClass == null) return ret;
            me = ret = AccessController.doPrivileged(new PrivilegedExceptionAction<RangerPluginClassLoader>(){

                @Override
                public RangerPluginClassLoader run() throws Exception {
                    return new RangerPluginClassLoader(pluginType, pluginClass);
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerPluginClassLoader.findClass(" + name + ")");
            }
            ret = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPluginClassLoader.findClass(" + name + "): calling childClassLoader().findClass() ");
                }
                ret = super.findClass(name);
            }
            catch (Throwable e) {
                MyClassLoader savedClassLoader;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPluginClassLoader.findClass(" + name + "): calling componentClassLoader.findClass()");
                }
                if ((savedClassLoader = this.getComponentClassLoader()) == null) break block6;
                ret = savedClassLoader.findClass(name);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoader.findClass(" + name + "): " + ret);
        }
        return ret;
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> ret;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("==> RangerPluginClassLoader.loadClass(" + name + ")");
            }
            ret = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPluginClassLoader.loadClass(" + name + "): calling childClassLoader.findClass()");
                }
                ret = super.loadClass(name);
            }
            catch (Throwable e) {
                MyClassLoader savedClassLoader;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPluginClassLoader.loadClass(" + name + "): calling componentClassLoader.loadClass()");
                }
                if ((savedClassLoader = this.getComponentClassLoader()) == null) break block6;
                ret = savedClassLoader.loadClass(name);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoader.loadClass(" + name + "): " + ret);
        }
        return ret;
    }

    @Override
    public URL findResource(String name) {
        URL ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoader.findResource(" + name + ") ");
        }
        if ((ret = super.findResource(name)) == null) {
            MyClassLoader savedClassLoader;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerPluginClassLoader.findResource(" + name + "): calling componentClassLoader.getResources()");
            }
            if ((savedClassLoader = this.getComponentClassLoader()) != null) {
                ret = savedClassLoader.getResource(name);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoader.findResource(" + name + "): " + ret);
        }
        return ret;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        MergeEnumeration ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoader.findResources(" + name + ") ");
        }
        ret = new MergeEnumeration(this.findResourcesUsingChildClassLoader(name), this.findResourcesUsingComponentClassLoader(name));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoader.findResources(" + name + ") ");
        }
        return ret;
    }

    public Enumeration<URL> findResourcesUsingChildClassLoader(String name) {
        Enumeration<URL> ret;
        block3: {
            ret = null;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPluginClassLoader.findResourcesUsingChildClassLoader(" + name + "): calling childClassLoader.findResources()");
                }
                ret = super.findResources(name);
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("RangerPluginClassLoader.findResourcesUsingChildClassLoader(" + name + "): class not found in child. Falling back to componentClassLoader", t);
            }
        }
        return ret;
    }

    public Enumeration<URL> findResourcesUsingComponentClassLoader(String name) {
        Enumeration<URL> ret;
        block5: {
            ret = null;
            try {
                MyClassLoader savedClassLoader;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RangerPluginClassLoader.findResourcesUsingComponentClassLoader(" + name + "): calling componentClassLoader.getResources()");
                }
                if ((savedClassLoader = this.getComponentClassLoader()) != null) {
                    ret = savedClassLoader.getResources(name);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<== RangerPluginClassLoader.findResourcesUsingComponentClassLoader(" + name + "): " + ret);
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("RangerPluginClassLoader.findResourcesUsingComponentClassLoader(" + name + "): class not found in componentClassLoader.", t);
            }
        }
        return ret;
    }

    public void activate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoader.activate()");
        }
        this.preActivateClassLoader.set(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoader.activate()");
        }
    }

    public void deactivate() {
        ClassLoader classLoader;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerPluginClassLoader.deactivate()");
        }
        if ((classLoader = this.preActivateClassLoader.get()) != null) {
            this.preActivateClassLoader.remove();
        } else {
            MyClassLoader savedClassLoader = this.getComponentClassLoader();
            if (savedClassLoader != null && savedClassLoader.getParent() != null) {
                classLoader = savedClassLoader.getParent();
            }
        }
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            LOG.warn("RangerPluginClassLoader.deactivate() was not successful. Couldn't not get the saved classLoader...");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerPluginClassLoader.deactivate()");
        }
    }

    private MyClassLoader getComponentClassLoader() {
        return componentClassLoader;
    }

    public ScriptEngine getScriptEngine(String engineName) {
        ScriptEngine ret;
        ScriptEngineManager manager;
        MyClassLoader savedClassLoader;
        ClassLoader classLoader = this.preActivateClassLoader.get();
        if (classLoader == null && (savedClassLoader = this.getComponentClassLoader()) != null && savedClassLoader.getParent() != null) {
            classLoader = savedClassLoader.getParent();
        }
        ScriptEngineManager scriptEngineManager = manager = classLoader != null ? new ScriptEngineManager(classLoader) : new ScriptEngineManager();
        if (LOG.isDebugEnabled()) {
            List<ScriptEngineFactory> factories = manager.getEngineFactories();
            if (factories == null || factories.size() == 0) {
                LOG.debug("List of scriptEngineFactories is empty!!");
            } else {
                for (ScriptEngineFactory factory : factories) {
                    LOG.debug("engineName=" + factory.getEngineName() + ", language=" + factory.getLanguageName());
                }
            }
        }
        if ((ret = manager.getEngineByName(engineName)) == null) {
            LOG.error("scriptEngine for JavaScript is null!!");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("scriptEngine for JavaScript:[" + ret + "]");
        }
        return ret;
    }

    static class MergeEnumeration
    implements Enumeration<URL> {
        Enumeration<URL> e1 = null;
        Enumeration<URL> e2 = null;

        public MergeEnumeration(Enumeration<URL> e1, Enumeration<URL> e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e1 != null && this.e1.hasMoreElements() || this.e2 != null && this.e2.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL ret = null;
            if (this.e1 != null && this.e1.hasMoreElements()) {
                ret = this.e1.nextElement();
            } else if (this.e2 != null && this.e2.hasMoreElements()) {
                ret = this.e2.nextElement();
            }
            return ret;
        }
    }

    static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader realClassLoader) {
            super(realClassLoader);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return super.findClass(name);
        }
    }
}

