/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.query.engine.retriever.ConfiguredObjectRetriever;
import org.apache.qpid.server.query.engine.retriever.EntityRetriever;

public class BindingRetriever<C extends ConfiguredObject<?>>
extends ConfiguredObjectRetriever<C>
implements EntityRetriever<C> {
    private final Class<C> _type = Exchange.class;
    private final List<String> _fieldNames = new ImmutableList.Builder().add((Object)"exchange").add((Object)"bindingKey").add((Object)"name").add((Object)"type").add((Object)"arguments").add((Object)"destination").build();
    private final BiFunction<ConfiguredObject<?>, Binding, Map<String, Object>> _bindingMapping = (parent, binding) -> ImmutableMap.builder().put((Object)this._fieldNames.get(0), (Object)parent.getName()).put((Object)this._fieldNames.get(1), (Object)binding.getBindingKey()).put((Object)this._fieldNames.get(2), (Object)binding.getName()).put((Object)this._fieldNames.get(3), (Object)binding.getType()).put((Object)this._fieldNames.get(4), (Object)binding.getArguments()).put((Object)this._fieldNames.get(5), (Object)binding.getDestination()).build();

    @Override
    public Stream<Map<String, ?>> retrieve(C broker) {
        Stream<Exchange> stream = this.retrieve(broker, this._type).map(exchange -> (Exchange)exchange);
        return stream.flatMap(exchange -> exchange.getBindings().stream().map(binding -> this._bindingMapping.apply((ConfiguredObject<?>)exchange, (Binding)binding)));
    }

    @Override
    public List<String> getFieldNames() {
        return this._fieldNames;
    }
}

