/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.converter;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContextHolder;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;

public final class NumberConverter {
    private static final Map<Class<?>, Map<Class<?>, Function<Object, ?>>> CONVERSIONS = ImmutableMap.builder().put(Double.class, (Object)ImmutableMap.builder().put(BigDecimal.class, arg -> ((BigDecimal)arg).doubleValue()).put(Byte.class, arg -> ((Byte)arg).doubleValue()).put(Double.class, arg -> arg).put(Float.class, arg -> ((Float)arg).doubleValue()).put(Integer.class, arg -> ((Integer)arg).doubleValue()).put(Long.class, arg -> ((Long)arg).doubleValue()).put(Number.class, arg -> ((Number)arg).doubleValue()).put(Short.class, arg -> ((Short)arg).doubleValue()).put(String.class, arg -> Double.parseDouble((String)arg)).build()).put(Long.class, (Object)ImmutableMap.builder().put(BigDecimal.class, arg -> ((BigDecimal)arg).longValue()).put(Byte.class, arg -> ((Byte)arg).longValue()).put(Double.class, arg -> ((Double)arg).longValue()).put(Float.class, arg -> ((Float)arg).longValue()).put(Integer.class, arg -> ((Integer)arg).longValue()).put(Long.class, arg -> arg).put(Number.class, arg -> ((Number)arg).longValue()).put(Short.class, arg -> ((Short)arg).longValue()).put(String.class, arg -> Double.valueOf(Double.parseDouble((String)arg)).longValue()).build()).build();

    private NumberConverter() {
    }

    private static QuerySettings querySettings() {
        return (QuerySettings)EvaluationContextHolder.getEvaluationContext().get("query.settings");
    }

    private static int decimalDigits() {
        return NumberConverter.querySettings().getDecimalDigits();
    }

    private static BigDecimal maxBigDecimalValue() {
        return NumberConverter.querySettings().getMaxBigDecimalValue();
    }

    private static RoundingMode roundingMode() {
        return NumberConverter.querySettings().getRoundingMode();
    }

    private static Function<Object, ?> getConversion(Class<?> type, Object value) {
        Map<Class<?>, Function<Object, ?>> availableConversions = CONVERSIONS.get(type);
        if (availableConversions == null) {
            throw QueryParsingException.of("Conversion of value '%s' of type '%s' to target type '%s' not supported", value, StringUtils.getClassName(value));
        }
        Function<Object, ?> function = availableConversions.get(value.getClass());
        if (function == null) {
            throw QueryParsingException.of("Conversion of value '%s' of type '%s' to target type '%s' not supported", value, StringUtils.getClassName(value));
        }
        return function;
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        return (Long)NumberConverter.getConversion(Long.class, value).apply(value);
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        return (Double)NumberConverter.getConversion(Double.class, value).apply(value);
    }

    public static <R> R narrow(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (bigDecimal.compareTo(NumberConverter.maxBigDecimalValue()) >= 0 || bigDecimal.compareTo(NumberConverter.maxBigDecimalValue().negate()) <= 0) {
            throw QueryParsingException.of("Reached maximal allowed big decimal value: %s", bigDecimal);
        }
        if (bigDecimal.doubleValue() == (double)((int)bigDecimal.doubleValue())) {
            return (R)Integer.valueOf(bigDecimal.intValue());
        }
        if (bigDecimal.doubleValue() == (double)((long)bigDecimal.doubleValue()) && bigDecimal.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) <= 0 && bigDecimal.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) >= 0) {
            return (R)Long.valueOf(bigDecimal.longValue());
        }
        if (bigDecimal.scale() != 0 && bigDecimal.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) <= 0 && bigDecimal.compareTo(BigDecimal.valueOf(-1.7976931348623157E308)) >= 0) {
            return (R)Double.valueOf(bigDecimal.setScale(NumberConverter.decimalDigits(), NumberConverter.roundingMode()).doubleValue());
        }
        return (R)bigDecimal;
    }

    public static Number narrow(Number number) {
        if (number == null) {
            return null;
        }
        return (Number)NumberConverter.narrow(new BigDecimal(number.toString()));
    }

    public static boolean isNumber(String source) {
        try {
            Integer.parseInt(source);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

