/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.portunification;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.qpid.server.management.plugin.portunification.MarkableEndPoint;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TlsOrPlainConnectionFactory
extends AbstractConnectionFactory {
    private final SslContextFactory _sslContextFactory;
    private final String _nextProtocol;

    public TlsOrPlainConnectionFactory(@Name(value="sslContextFactory") SslContextFactory factory, @Name(value="nextProtocol") String nextProtocol) {
        super("SSL");
        this._sslContextFactory = factory == null ? new SslContextFactory() : factory;
        this._nextProtocol = nextProtocol;
        this.addBean(this._sslContextFactory);
    }

    protected void doStart() throws Exception {
        super.doStart();
        SSLEngine engine = this._sslContextFactory.newSSLEngine();
        engine.setUseClientMode(false);
        SSLSession session = engine.getSession();
        if (session.getPacketBufferSize() > this.getInputBufferSize()) {
            this.setInputBufferSize(session.getPacketBufferSize());
        }
        engine.closeInbound();
        engine.closeOutbound();
    }

    public PlainOrTlsConnection newConnection(Connector connector, EndPoint realEndPoint) {
        MarkableEndPoint endPoint = new MarkableEndPoint(realEndPoint);
        PlainOrTlsConnection plainOrTlsConnection = new PlainOrTlsConnection(connector, endPoint);
        endPoint.setConnection(plainOrTlsConnection);
        return plainOrTlsConnection;
    }

    public String toString() {
        return String.format("%s@%x{%s->%s}", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getProtocol(), this._nextProtocol);
    }

    class PlainOrTlsConnection
    implements Connection {
        private final Logger LOG = Log.getLogger(PlainOrTlsConnection.class);
        private static final int TLS_HEADER_SIZE = 6;
        private final long _created = System.currentTimeMillis();
        private final Connector _connector;
        private final MarkableEndPoint _endPoint;
        private final Callback _fillableCallback = new Callback(){

            public void succeeded() {
                PlainOrTlsConnection.this.onFillable();
            }
        };
        private final ByteBuffer _tlsDeterminationBuf = BufferUtil.allocate((int)6);
        private final List<Connection.Listener> _listeners = new CopyOnWriteArrayList<Connection.Listener>();
        private volatile AbstractConnection _actualConnection;

        PlainOrTlsConnection(Connector connector, MarkableEndPoint endPoint) {
            this._connector = connector;
            this._endPoint = endPoint;
            this._endPoint.mark();
        }

        public void addListener(Connection.Listener listener) {
            if (this._actualConnection == null) {
                this._listeners.add(listener);
            } else {
                this._actualConnection.addListener(listener);
            }
        }

        public void removeListener(Connection.Listener listener) {
            this._listeners.remove(listener);
        }

        public void onOpen() {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("onOpen {}", new Object[]{this});
            }
            this._endPoint.fillInterested(this._fillableCallback);
            for (Connection.Listener listener : this._listeners) {
                listener.onOpened((Connection)this);
            }
        }

        public void onClose() {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("onClose {}", new Object[]{this});
            }
            for (Connection.Listener listener : this._listeners) {
                listener.onClosed((Connection)this);
            }
        }

        public EndPoint getEndPoint() {
            return this._endPoint;
        }

        public void close() {
            try {
                if (this._endPoint != null) {
                    this._endPoint.close();
                }
            }
            finally {
                if (this._actualConnection != null) {
                    this._actualConnection.close();
                }
            }
        }

        public boolean onIdleExpired() {
            return this._actualConnection == null || this._actualConnection.onIdleExpired();
        }

        public long getMessagesIn() {
            return this._actualConnection == null ? -1L : this._actualConnection.getMessagesIn();
        }

        public long getMessagesOut() {
            return this._actualConnection == null ? -1L : this._actualConnection.getMessagesOut();
        }

        public long getBytesIn() {
            return this._actualConnection == null ? -1L : this._actualConnection.getBytesIn();
        }

        public long getBytesOut() {
            return this._actualConnection == null ? -1L : this._actualConnection.getBytesOut();
        }

        public long getCreatedTimeStamp() {
            return this._created;
        }

        public final String toString() {
            return String.format("%s<-%s", this.toConnectionString(), this.getEndPoint());
        }

        String toConnectionString() {
            return String.format("%s@%h", this.getClass().getSimpleName(), this);
        }

        void onFillable() {
            if (this._actualConnection != null) {
                this._actualConnection.onFillable();
            } else {
                try {
                    int filled = this.getEndPoint().fill(this._tlsDeterminationBuf);
                    if (filled < 0) {
                        this.close();
                        return;
                    }
                    int remaining = this._tlsDeterminationBuf.remaining();
                    if (remaining >= 6) {
                        byte[] array = this._tlsDeterminationBuf.array();
                        boolean isTLS = this.looksLikeSSLv2ClientHello(array) || this.looksLikeSSLv3ClientHello(array);
                        this.LOG.debug("new connection tls={} endpoint address={}", new Object[]{isTLS, this.getEndPoint().getRemoteAddress()});
                        this._endPoint.rewind();
                        if (isTLS) {
                            SSLEngine engine = TlsOrPlainConnectionFactory.this._sslContextFactory.newSSLEngine(this._endPoint.getRemoteAddress());
                            engine.setUseClientMode(false);
                            SslConnection sslConnection = this.newSslConnection(this._connector, this._endPoint, engine);
                            sslConnection.setInputBufferSize(TlsOrPlainConnectionFactory.this.getInputBufferSize());
                            sslConnection.setRenegotiationAllowed(TlsOrPlainConnectionFactory.this._sslContextFactory.isRenegotiationAllowed());
                            this._actualConnection = sslConnection;
                            if (this._connector instanceof ContainerLifeCycle) {
                                ContainerLifeCycle container = (ContainerLifeCycle)this._connector;
                                container.getBeans(SslHandshakeListener.class).forEach(arg_0 -> ((SslConnection)sslConnection).addHandshakeListener(arg_0));
                            }
                            TlsOrPlainConnectionFactory.this.getBeans(SslHandshakeListener.class).forEach(arg_0 -> ((SslConnection)sslConnection).addHandshakeListener(arg_0));
                            ConnectionFactory next = this._connector.getConnectionFactory(TlsOrPlainConnectionFactory.this._nextProtocol);
                            SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
                            Connection connection = next.newConnection(this._connector, (EndPoint)decryptedEndPoint);
                            decryptedEndPoint.setConnection(connection);
                        } else {
                            ConnectionFactory next = this._connector.getConnectionFactory(TlsOrPlainConnectionFactory.this._nextProtocol);
                            this._actualConnection = (AbstractConnection)next.newConnection(this._connector, (EndPoint)this._endPoint);
                            this._endPoint.setConnection((Connection)this._actualConnection);
                        }
                        this._actualConnection.onOpen();
                        for (Connection.Listener listener : this._listeners) {
                            this._actualConnection.addListener(listener);
                        }
                    } else {
                        this.LOG.debug("Too few bytes to make determination received : {} required: {}", new Object[]{remaining, 6});
                        this._endPoint.fillInterested(this._fillableCallback);
                    }
                }
                catch (IOException e) {
                    this.close();
                }
            }
        }

        private boolean looksLikeSSLv3ClientHello(byte[] headerBytes) {
            return headerBytes[0] == 22 && headerBytes[1] == 3 && (headerBytes[2] == 0 || headerBytes[2] == 1 || headerBytes[2] == 2 || headerBytes[2] == 3) && headerBytes[5] == 1;
        }

        private boolean looksLikeSSLv2ClientHello(byte[] headerBytes) {
            return headerBytes[0] == -128 && headerBytes[3] == 3 && (headerBytes[4] == 0 || headerBytes[4] == 1 || headerBytes[4] == 2 || headerBytes[4] == 3);
        }

        private SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
            return new SslConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, engine);
        }
    }
}

