/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.servlet.ServletConnectionPrincipal;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.auth.ManagementConnectionPrincipal;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class AuthenticationCheckFilter
implements Filter {
    public static final String INIT_PARAM_ALLOWED = "allowed";
    private String _allowed = null;
    private Broker _broker;
    private HttpManagementConfiguration _managementConfiguration;

    public void init(FilterConfig filterConfig) throws ServletException {
        String allowed = filterConfig.getInitParameter(INIT_PARAM_ALLOWED);
        if (allowed != null && !"".equals(allowed)) {
            this._allowed = allowed;
        }
        ServletContext servletContext = filterConfig.getServletContext();
        this._broker = HttpManagementUtil.getBroker(servletContext);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(servletContext);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isPreemptiveAuthentication = false;
        try {
            Subject subject = HttpManagementUtil.getAuthorisedSubject(httpRequest);
            if (subject == null) {
                if (this._allowed != null && httpRequest.getServletPath().startsWith(this._allowed)) {
                    subject = new Subject(true, Collections.singleton(new ServletConnectionPrincipal(httpRequest)), Collections.emptySet(), Collections.emptySet());
                } else {
                    subject = this.tryPreemptiveAuthentication(httpRequest);
                    isPreemptiveAuthentication = true;
                }
            } else {
                Set<Principal> principals = subject.getPrincipals();
                LinkedHashSet<Principal> newPrincipals = new LinkedHashSet<Principal>();
                for (Principal principal : principals) {
                    if (principal instanceof ManagementConnectionPrincipal) continue;
                    newPrincipals.add(principal);
                }
                subject = new Subject(false, principals, subject.getPublicCredentials(), subject.getPrivateCredentials());
                ServletConnectionPrincipal principal = new ServletConnectionPrincipal(httpRequest);
                subject.getPrincipals().add((Principal)((Object)principal));
                subject.setReadOnly();
            }
            this.doFilterChainAs(request, response, chain, subject);
        }
        catch (AccessControlException e) {
            httpResponse.sendError(403);
            this.invalidateSession(httpRequest);
            return;
        }
        catch (SecurityException e) {
            httpResponse.sendError(401);
            this.invalidateSession(httpRequest);
            return;
        }
        finally {
            if (isPreemptiveAuthentication) {
                this.invalidateSession(httpRequest);
            }
        }
    }

    private void doFilterChainAs(final ServletRequest request, final ServletResponse response, final FilterChain chain, Subject subject) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, ServletException {
                    chain.doFilter(request, response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ConnectionScopedRuntimeException(e.getCause());
        }
    }

    private Subject tryPreemptiveAuthentication(HttpServletRequest httpRequest) {
        Subject subject = HttpManagementUtil.tryToAuthenticate(httpRequest, this._managementConfiguration);
        if (subject == null) {
            throw new SecurityException("Only authenticated users can access the management interface");
        }
        subject = HttpManagementUtil.createServletConnectionSubject(httpRequest, subject);
        HttpManagementUtil.assertManagementAccess(this._broker, subject);
        return subject;
    }

    private void invalidateSession(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }
}

