/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import org.apache.qpid.server.logging.logback.EffectiveLevelFilter;

public class LoggerNameAndLevelFilter
extends Filter<ILoggingEvent>
implements EffectiveLevelFilter {
    private final Filter<ILoggingEvent> _filter;
    private final String _loggerName;
    private volatile Level _level;

    public LoggerNameAndLevelFilter(String loggerName, Level level) {
        this._level = level;
        this._loggerName = loggerName;
        this._filter = this.createFilter(loggerName);
    }

    public FilterReply decide(ILoggingEvent event) {
        return this._filter.decide((Object)event);
    }

    public void setLevel(Level level) {
        this._level = level;
    }

    @Override
    public Level getLevel() {
        return this._level;
    }

    public String getLoggerName() {
        return this._loggerName;
    }

    protected Filter<ILoggingEvent> createFilter(final String loggerName) {
        if (loggerName == null || "".equals(loggerName) || "ROOT".equals(loggerName)) {
            return new Filter<ILoggingEvent>(){

                public FilterReply decide(ILoggingEvent event) {
                    return LoggerNameAndLevelFilter.this.getFilterReply(event.getLevel());
                }
            };
        }
        if (loggerName.endsWith(".*")) {
            final String prefixName = loggerName.substring(0, loggerName.length() - 2);
            return new Filter<ILoggingEvent>(){

                public FilterReply decide(ILoggingEvent event) {
                    if (event.getLoggerName().startsWith(prefixName)) {
                        return LoggerNameAndLevelFilter.this.getFilterReply(event.getLevel());
                    }
                    return FilterReply.NEUTRAL;
                }
            };
        }
        return new Filter<ILoggingEvent>(){

            public FilterReply decide(ILoggingEvent event) {
                if (event.getLoggerName().equals(loggerName)) {
                    return LoggerNameAndLevelFilter.this.getFilterReply(event.getLevel());
                }
                return FilterReply.NEUTRAL;
            }
        };
    }

    private FilterReply getFilterReply(Level eventLevel) {
        if (this._level == Level.OFF) {
            return FilterReply.DENY;
        }
        if (eventLevel.isGreaterOrEqual(this._level)) {
            return FilterReply.ACCEPT;
        }
        return FilterReply.NEUTRAL;
    }

    @Override
    public Level getEffectiveLevel(Logger logger) {
        if (this._loggerName == null || "".equals(this._loggerName) || "ROOT".equals(this._loggerName) || this._loggerName.endsWith(".*") && logger.getName().startsWith(this._loggerName.substring(0, this._loggerName.length() - 2)) || this._loggerName.equals(logger.getName())) {
            return this._level;
        }
        return Level.OFF;
    }
}

