/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.UnsignedLongWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;

public class TransferWriter
extends AbstractDescribedTypeWriter<Transfer> {
    private static final ValueWriter<UnsignedLong> DESCRIPTOR_WRITER = UnsignedLongWriter.getWriter((byte)20);
    private static final ValueWriter.Factory<Transfer> FACTORY = new ValueWriter.Factory<Transfer>(){

        @Override
        public ValueWriter<Transfer> newInstance(ValueWriter.Registry registry, Transfer object) {
            return new TransferWriter(registry, object);
        }
    };

    private TransferWriter(ValueWriter.Registry registry, Transfer object) {
        super(DESCRIPTOR_WRITER, new Writer(registry, object));
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Transfer.class, FACTORY);
    }

    private static class Writer
    extends AbstractListWriter<Transfer> {
        private final Transfer _value;
        private final int _count;
        private int _field;

        public Writer(ValueWriter.Registry registry, Transfer object) {
            super(registry);
            this._value = object;
            this._count = this.calculateCount();
        }

        private int calculateCount() {
            if (this._value.getBatchable() != null) {
                return 11;
            }
            if (this._value.getAborted() != null) {
                return 10;
            }
            if (this._value.getResume() != null) {
                return 9;
            }
            if (this._value.getState() != null) {
                return 8;
            }
            if (this._value.getRcvSettleMode() != null) {
                return 7;
            }
            if (this._value.getMore() != null) {
                return 6;
            }
            if (this._value.getSettled() != null) {
                return 5;
            }
            if (this._value.getMessageFormat() != null) {
                return 4;
            }
            if (this._value.getDeliveryTag() != null) {
                return 3;
            }
            if (this._value.getDeliveryId() != null) {
                return 2;
            }
            if (this._value.getHandle() != null) {
                return 1;
            }
            return 0;
        }

        @Override
        protected int getCount() {
            return this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return this._value.getHandle();
                }
                case 1: {
                    return this._value.getDeliveryId();
                }
                case 2: {
                    return this._value.getDeliveryTag();
                }
                case 3: {
                    return this._value.getMessageFormat();
                }
                case 4: {
                    return this._value.getSettled();
                }
                case 5: {
                    return this._value.getMore();
                }
                case 6: {
                    return this._value.getRcvSettleMode();
                }
                case 7: {
                    return this._value.getState();
                }
                case 8: {
                    return this._value.getResume();
                }
                case 9: {
                    return this._value.getAborted();
                }
                case 10: {
                    return this._value.getBatchable();
                }
            }
            return null;
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

