/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;

public abstract class AbstractLazyConstructor<T>
implements TypeConstructor<T> {
    private final int _originalPosition;

    AbstractLazyConstructor(int originalPosition) {
        this._originalPosition = originalPosition;
    }

    @Override
    public final T construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        this.skipValue(in);
        try (QpidByteBuffer encoding = in.duplicate();){
            encoding.position(this._originalPosition);
            encoding.limit(in.position());
            T t = this.createObject(encoding, handler);
            return t;
        }
    }

    protected abstract T createObject(QpidByteBuffer var1, ValueHandler var2);

    protected abstract void skipValue(QpidByteBuffer var1) throws AmqpErrorException;
}

