/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.messaging;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v1_0.CompositeType;
import org.apache.qpid.server.protocol.v1_0.CompositeTypeField;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.DistributionMode;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Filter;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusExpiryPolicy;

@CompositeType(symbolicDescriptor="amqp:source:list", numericDescriptor=40L)
public class Source
implements BaseSource {
    @CompositeTypeField(index=0)
    private String _address;
    @CompositeTypeField(index=1)
    private TerminusDurability _durable;
    @CompositeTypeField(index=2)
    private TerminusExpiryPolicy _expiryPolicy;
    @CompositeTypeField(index=3)
    private UnsignedInteger _timeout;
    @CompositeTypeField(index=4)
    private Boolean _dynamic;
    @CompositeTypeField(index=5, deserializationConverter="org.apache.qpid.server.protocol.v1_0.DeserializationFactories.convertToNodeProperties")
    private Map<Symbol, Object> _dynamicNodeProperties;
    @CompositeTypeField(index=6, deserializationConverter="org.apache.qpid.server.protocol.v1_0.DeserializationFactories.convertToDistributionMode")
    private DistributionMode _distributionMode;
    @CompositeTypeField(index=7)
    private Map<Symbol, Filter> _filter;
    @CompositeTypeField(index=8)
    private Outcome _defaultOutcome;
    @CompositeTypeField(index=9)
    private Symbol[] _outcomes;
    @CompositeTypeField(index=10)
    private Symbol[] _capabilities;

    public Source() {
    }

    public Source(Source source) {
        this._address = source.getAddress();
        this._durable = source.getDurable();
        this._expiryPolicy = source.getExpiryPolicy();
        this._timeout = source.getTimeout();
        this._dynamic = source.getDynamic();
        Map<Symbol, Object> dynamicNodeProperties = source.getDynamicNodeProperties();
        this._dynamicNodeProperties = dynamicNodeProperties == null ? null : new LinkedHashMap<Symbol, Object>(dynamicNodeProperties);
        this._distributionMode = source.getDistributionMode();
        Map<Symbol, Filter> filter = source.getFilter();
        this._filter = filter == null ? null : new LinkedHashMap<Symbol, Filter>(filter);
        this._defaultOutcome = source.getDefaultOutcome();
        Symbol[] outcomes = source.getOutcomes();
        this._outcomes = outcomes == null ? null : Arrays.copyOf(outcomes, outcomes.length);
        Symbol[] capabilities = source.getCapabilities();
        this._capabilities = capabilities == null ? null : Arrays.copyOf(capabilities, capabilities.length);
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public TerminusDurability getDurable() {
        return this._durable;
    }

    public void setDurable(TerminusDurability durable) {
        this._durable = durable;
    }

    public TerminusExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    public void setExpiryPolicy(TerminusExpiryPolicy expiryPolicy) {
        this._expiryPolicy = expiryPolicy;
    }

    public UnsignedInteger getTimeout() {
        return this._timeout;
    }

    public void setTimeout(UnsignedInteger timeout) {
        this._timeout = timeout;
    }

    public Boolean getDynamic() {
        return this._dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this._dynamic = dynamic;
    }

    public Map<Symbol, Object> getDynamicNodeProperties() {
        return this._dynamicNodeProperties;
    }

    public void setDynamicNodeProperties(Map<Symbol, Object> dynamicNodeProperties) {
        this._dynamicNodeProperties = dynamicNodeProperties;
    }

    public DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public void setDistributionMode(DistributionMode distributionMode) {
        this._distributionMode = distributionMode;
    }

    public Map<Symbol, Filter> getFilter() {
        return this._filter;
    }

    public void setFilter(Map<Symbol, Filter> filter) {
        this._filter = filter;
    }

    public Outcome getDefaultOutcome() {
        return this._defaultOutcome;
    }

    public void setDefaultOutcome(Outcome defaultOutcome) {
        this._defaultOutcome = defaultOutcome;
    }

    public Symbol[] getOutcomes() {
        return this._outcomes;
    }

    public void setOutcomes(Symbol ... outcomes) {
        this._outcomes = outcomes;
    }

    public Symbol[] getCapabilities() {
        return this._capabilities;
    }

    public void setCapabilities(Symbol[] capabilities) {
        this._capabilities = capabilities;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Source{");
        int origLength = builder.length();
        if (this._address != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("address=").append(this._address);
        }
        if (this._durable != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("durable=").append(this._durable);
        }
        if (this._expiryPolicy != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("expiryPolicy=").append(this._expiryPolicy);
        }
        if (this._timeout != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("timeout=").append(this._timeout);
        }
        if (this._dynamic != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("dynamic=").append(this._dynamic);
        }
        if (this._dynamicNodeProperties != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("dynamicNodeProperties=").append(this._dynamicNodeProperties);
        }
        if (this._distributionMode != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("distributionMode=").append(this._distributionMode);
        }
        if (this._filter != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("filter=").append(this._filter);
        }
        if (this._defaultOutcome != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("defaultOutcome=").append(this._defaultOutcome);
        }
        if (this._outcomes != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("outcomes=").append(Arrays.toString(this._outcomes));
        }
        if (this._capabilities != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("capabilities=").append(Arrays.toString(this._capabilities));
        }
        builder.append('}');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        if (this._address != null ? !this._address.equals(source._address) : source._address != null) {
            return false;
        }
        if (this._durable != null ? !this._durable.equals(source._durable) : source._durable != null) {
            return false;
        }
        if (this._expiryPolicy != null ? !this._expiryPolicy.equals(source._expiryPolicy) : source._expiryPolicy != null) {
            return false;
        }
        if (this._timeout != null ? !this._timeout.equals(source._timeout) : source._timeout != null) {
            return false;
        }
        if (this._dynamic != null ? !this._dynamic.equals(source._dynamic) : source._dynamic != null) {
            return false;
        }
        if (this._dynamicNodeProperties != null ? !this._dynamicNodeProperties.equals(source._dynamicNodeProperties) : source._dynamicNodeProperties != null) {
            return false;
        }
        if (this._distributionMode != null ? !this._distributionMode.equals(source._distributionMode) : source._distributionMode != null) {
            return false;
        }
        if (this._filter != null ? !this._filter.equals(source._filter) : source._filter != null) {
            return false;
        }
        if (this._defaultOutcome != null) {
            if (source._defaultOutcome == null) {
                return false;
            }
            if (this._defaultOutcome.getSymbol() != null) {
                if (source._defaultOutcome.getSymbol() == null) {
                    return false;
                }
                if (!this._defaultOutcome.getSymbol().equals(source._defaultOutcome.getSymbol())) {
                    return false;
                }
            } else if (source._defaultOutcome.getSymbol() != null) {
                return false;
            }
        } else if (source._defaultOutcome != null) {
            return false;
        }
        return Arrays.equals(this._outcomes, source._outcomes) && Arrays.equals(this._capabilities, source._capabilities);
    }

    public int hashCode() {
        int result = this._address != null ? this._address.hashCode() : 0;
        result = 31 * result + (this._durable != null ? this._durable.hashCode() : 0);
        result = 31 * result + (this._expiryPolicy != null ? this._expiryPolicy.hashCode() : 0);
        result = 31 * result + (this._timeout != null ? this._timeout.hashCode() : 0);
        result = 31 * result + (this._dynamic != null ? this._dynamic.hashCode() : 0);
        result = 31 * result + (this._dynamicNodeProperties != null ? this._dynamicNodeProperties.hashCode() : 0);
        result = 31 * result + (this._distributionMode != null ? this._distributionMode.hashCode() : 0);
        result = 31 * result + (this._filter != null ? this._filter.hashCode() : 0);
        result = 31 * result + (this._defaultOutcome != null ? this._defaultOutcome.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this._outcomes);
        result = 31 * result + Arrays.hashCode(this._capabilities);
        return result;
    }
}

