/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type;

import java.math.BigInteger;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    private static final long serialVersionUID = 1L;
    private static final BigInteger TWO_TO_THE_SIXTY_FOUR = new BigInteger(new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final UnsignedLong[] cachedValues = new UnsignedLong[256];
    public static final UnsignedLong ZERO;
    public static final UnsignedLong ONE;
    private final long _underlying;

    public UnsignedLong(long underlying) {
        this._underlying = underlying;
    }

    @Override
    public int intValue() {
        return (int)this._underlying;
    }

    @Override
    public long longValue() {
        return this._underlying;
    }

    public BigInteger bigIntegerValue() {
        if (this._underlying >= 0L) {
            return BigInteger.valueOf(this._underlying);
        }
        return TWO_TO_THE_SIXTY_FOUR.add(BigInteger.valueOf(this._underlying));
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnsignedLong that = (UnsignedLong)o;
        return this._underlying == that._underlying;
    }

    @Override
    public int compareTo(UnsignedLong o) {
        return this.bigIntegerValue().compareTo(o.bigIntegerValue());
    }

    public int hashCode() {
        return (int)(this._underlying ^ this._underlying >>> 32);
    }

    public String toString() {
        return String.valueOf(this.bigIntegerValue());
    }

    public static UnsignedLong valueOf(long underlying) {
        if ((underlying & 0xFFL) == underlying) {
            return cachedValues[(int)underlying];
        }
        return new UnsignedLong(underlying);
    }

    public static UnsignedLong valueOf(String value) {
        BigInteger bigInt = new BigInteger(value);
        if (bigInt.signum() == -1 || bigInt.bitCount() > 64) {
            throw new NumberFormatException("Value \"" + value + "\" lies outside the range [" + 0L + "- 2^64).");
        }
        if (bigInt.compareTo(LONG_MAX_VALUE) >= 0) {
            return UnsignedLong.valueOf(bigInt.longValue());
        }
        return UnsignedLong.valueOf(TWO_TO_THE_SIXTY_FOUR.subtract(bigInt).negate().longValue());
    }

    public UnsignedLong add(UnsignedLong unsignedLong) {
        return UnsignedLong.valueOf(this._underlying + unsignedLong._underlying);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            UnsignedLong.cachedValues[i] = new UnsignedLong(i);
        }
        ZERO = cachedValues[0];
        ONE = cachedValues[1];
    }
}

