/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractMapWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public class MapWriter
extends AbstractMapWriter<Map> {
    private final Map _map;
    private Object _value;
    private Iterator<Map.Entry> _iterator;
    private static ValueWriter.Factory<Map> FACTORY = new ValueWriter.Factory<Map>(){

        @Override
        public ValueWriter<Map> newInstance(ValueWriter.Registry registry, Map object) {
            return new MapWriter(registry, object);
        }
    };

    private MapWriter(ValueWriter.Registry registry, Map object) {
        super(registry, object);
        this._map = object;
        this._iterator = object.entrySet().iterator();
    }

    @Override
    protected int getMapCount() {
        return this._map.size();
    }

    @Override
    protected boolean hasMapNext() {
        return this._iterator.hasNext();
    }

    @Override
    protected Object nextKey() {
        Map.Entry entry = this._iterator.next();
        this._value = entry.getValue();
        return entry.getKey();
    }

    @Override
    protected Object nextValue() {
        Object value = this._value;
        this._value = null;
        return value;
    }

    @Override
    protected void onReset() {
        this._iterator = this._map.entrySet().iterator();
        this._value = null;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Map.class, FACTORY);
    }
}

