/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store.bdb;

import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v1_0.store.LinkStore;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreFactory;
import org.apache.qpid.server.protocol.v1_0.store.bdb.BDBLinkStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.BDBEnvironmentContainer;

@PluggableService
public class BDBLinkStoreFactory
implements LinkStoreFactory {
    private static final String TYPE = "BDB";

    public String getType() {
        return TYPE;
    }

    public LinkStore create(NamedAddressSpace addressSpace) {
        VirtualHost virtualHost = (VirtualHost)addressSpace;
        if (virtualHost instanceof BDBEnvironmentContainer) {
            return new BDBLinkStore((BDBEnvironmentContainer)virtualHost);
        }
        if (virtualHost.getParent() instanceof BDBEnvironmentContainer) {
            return new BDBLinkStore((BDBEnvironmentContainer)virtualHost.getParent());
        }
        throw new StoreException("Cannot create BDB Link Store for " + addressSpace);
    }

    public boolean supports(NamedAddressSpace addressSpace) {
        if (addressSpace instanceof VirtualHost) {
            if (addressSpace instanceof BDBEnvironmentContainer) {
                return true;
            }
            if (((VirtualHost)addressSpace).getParent() instanceof BDBEnvironmentContainer) {
                return true;
            }
        }
        return false;
    }

    public int getPriority() {
        return 100;
    }
}

