/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store.bdb;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Collection;
import java.util.HashSet;
import org.apache.qpid.server.model.ModelVersion;
import org.apache.qpid.server.protocol.v1_0.LinkDefinition;
import org.apache.qpid.server.protocol.v1_0.LinkDefinitionImpl;
import org.apache.qpid.server.protocol.v1_0.LinkKey;
import org.apache.qpid.server.protocol.v1_0.store.AbstractLinkStore;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreUpdater;
import org.apache.qpid.server.protocol.v1_0.store.bdb.LinkKeyEntryBinding;
import org.apache.qpid.server.protocol.v1_0.store.bdb.LinkValue;
import org.apache.qpid.server.protocol.v1_0.store.bdb.LinkValueEntryBinding;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.BDBEnvironmentContainer;
import org.apache.qpid.server.store.berkeleydb.BDBUtils;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBLinkStore
extends AbstractLinkStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBLinkStore.class);
    private static final String LINKS_DB_NAME = "AMQP_1_0_LINKS";
    private static final String LINKS_VERSION_DB_NAME = "AMQP_1_0_LINKS_VERSION";
    private final BDBEnvironmentContainer<?> _environmentContainer;

    BDBLinkStore(BDBEnvironmentContainer<?> environmentContainer) {
        this._environmentContainer = environmentContainer;
    }

    protected Collection<LinkDefinition<Source, Target>> doOpenAndLoad(LinkStoreUpdater updater) throws StoreException {
        try {
            return this.getLinkDefinitions(updater);
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Failed recovery of links", e);
        }
    }

    protected void doSaveLink(LinkDefinition<Source, Target> link) {
        try {
            Database linksDatabase = this.getEnvironmentFacade().openDatabase(LINKS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
            this.save(linksDatabase, null, link);
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException(String.format("Failed saving of link '%s'", new LinkKey(link)), e);
        }
    }

    protected void doDeleteLink(LinkDefinition<Source, Target> linkDefinition) {
        LinkKey linkKey = new LinkKey(linkDefinition);
        try {
            Database linksDatabase = this.getEnvironmentFacade().openDatabase(LINKS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            LinkKeyEntryBinding.getInstance().objectToEntry(linkKey, databaseEntry);
            OperationStatus status = linksDatabase.delete(null, databaseEntry);
            if (status != OperationStatus.SUCCESS) {
                LOGGER.debug(String.format("Unexpected status '%s' for deletion of '%s'", status, linkKey));
            }
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException(String.format("Failed deletion of link '%s'", linkKey), e);
        }
    }

    protected void doClose() {
    }

    protected void doDelete() {
        try {
            this.getEnvironmentFacade().deleteDatabase(LINKS_DB_NAME);
            this.getEnvironmentFacade().deleteDatabase(LINKS_VERSION_DB_NAME);
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Could not delete Link store: {}", (Object)e.getMessage());
        }
        catch (RuntimeException e) {
            this.getEnvironmentFacade().handleDatabaseException("Failed deletion of database", e);
            LOGGER.info("Failed to delete links database", (Throwable)e);
        }
    }

    public TerminusDurability getHighestSupportedTerminusDurability() {
        return TerminusDurability.CONFIGURATION;
    }

    private EnvironmentFacade getEnvironmentFacade() {
        return this._environmentContainer.getEnvironmentFacade();
    }

    private Collection<LinkDefinition<Source, Target>> getLinkDefinitions(LinkStoreUpdater updater) {
        Database linksDatabase = this.getEnvironmentFacade().openDatabase(LINKS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
        Collection<Object> links = new HashSet<LinkDefinition<Source, Target>>();
        ModelVersion currentVersion = new ModelVersion(8, 0);
        ModelVersion storedVersion = this.getStoredVersion();
        if (currentVersion.lessThan(storedVersion)) {
            throw new StoreException(String.format("Cannot downgrade preference store from '%s' to '%s'", storedVersion, currentVersion));
        }
        Cursor cursor = linksDatabase.openCursor(null, null);
        Object object = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            LinkKeyEntryBinding keyEntryBinding = LinkKeyEntryBinding.getInstance();
            LinkValueEntryBinding linkValueEntryBinding = LinkValueEntryBinding.getInstance();
            while (cursor.getNext(databaseEntry, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                LinkKey linkKey = (LinkKey)keyEntryBinding.entryToObject(databaseEntry);
                LinkValue linkValue = (LinkValue)linkValueEntryBinding.entryToObject(value);
                LinkDefinitionImpl link = new LinkDefinitionImpl(linkKey.getRemoteContainerId(), linkKey.getLinkName(), linkKey.getRole(), (BaseSource)linkValue.getSource(), (BaseTarget)linkValue.getTarget());
                links.add((LinkDefinition<Source, Target>)link);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (cursor != null) {
                if (object != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    cursor.close();
                }
            }
        }
        if (storedVersion.lessThan(currentVersion)) {
            links = updater.update(storedVersion.toString(), links);
            Transaction txn = this.getEnvironmentFacade().beginTransaction(null);
            try {
                linksDatabase = this.getEnvironmentFacade().clearDatabase(txn, LINKS_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
                for (LinkDefinition linkDefinition : links) {
                    this.save(linksDatabase, txn, (LinkDefinition<Source, Target>)linkDefinition);
                }
                this.updateVersion(txn, currentVersion.toString());
                txn.commit();
                linksDatabase.close();
            }
            catch (Exception e) {
                txn.abort();
                throw e;
            }
        }
        return links;
    }

    private void updateVersion(Transaction txn, String currentVersion) {
        Database linksVersionDb = this.getEnvironmentFacade().openDatabase(LINKS_VERSION_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        StringBinding.stringToEntry((String)currentVersion, (DatabaseEntry)key);
        LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
        linksVersionDb.put(txn, key, value);
    }

    private void save(Database database, Transaction txn, LinkDefinition<Source, Target> link) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        LinkKey linkKey = new LinkKey(link);
        LinkKeyEntryBinding.getInstance().objectToEntry(linkKey, key);
        LinkValueEntryBinding.getInstance().objectToEntry(new LinkValue(link), value);
        OperationStatus status = database.put(txn, key, value);
        if (status != OperationStatus.SUCCESS) {
            throw new StoreException(String.format("Cannot save link %s", linkKey));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelVersion getStoredVersion() throws RuntimeException {
        try (Cursor cursor = this.getLinksVersionDb().openCursor(null, null);){
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            ModelVersion storedVersion = null;
            while (cursor.getNext(key, value, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                String versionString = StringBinding.entryToString((DatabaseEntry)key);
                ModelVersion version = ModelVersion.fromString((String)versionString);
                if (storedVersion != null && !storedVersion.lessThan(version)) continue;
                storedVersion = version;
            }
            if (storedVersion == null) {
                throw new StoreException("No link version information.");
            }
            ModelVersion modelVersion = storedVersion;
            return modelVersion;
        }
        catch (RuntimeException e) {
            throw this.getEnvironmentFacade().handleDatabaseException("Cannot visit link version", e);
        }
    }

    private Database getLinksVersionDb() {
        Database linksVersionDb;
        try {
            DatabaseConfig config = new DatabaseConfig().setTransactional(true).setAllowCreate(false);
            linksVersionDb = this.getEnvironmentFacade().openDatabase(LINKS_VERSION_DB_NAME, config);
        }
        catch (DatabaseNotFoundException e) {
            this.updateVersion(null, "8.0");
            linksVersionDb = this.getEnvironmentFacade().openDatabase(LINKS_VERSION_DB_NAME, BDBUtils.DEFAULT_DATABASE_CONFIG);
        }
        return linksVersionDb;
    }
}

